/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.LogicOperator;
import act.db.jpa.sql.SqlDialect;
import act.db.jpa.sql.WhereComponent;
import act.db.jpa.sql.WhereComponentBase;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;

public class GroupWhereComponent
extends WhereComponentBase {
    private List<WhereComponent> subComponents;
    private LogicOperator op;

    public GroupWhereComponent(LogicOperator operator, List<WhereComponent> subComponents) {
        E.illegalArgumentIf((boolean)subComponents.isEmpty(), (String)"sub components cannot be empty");
        this.subComponents = (List)$.notNull(subComponents);
        this.op = (LogicOperator)((Object)$.notNull((Object)((Object)operator)));
    }

    public GroupWhereComponent(LogicOperator operator, WhereComponent ... subComponents) {
        E.illegalArgumentIf((0 == subComponents.length ? 1 : 0) != 0, (String)"sub components cannot be empty");
        this.subComponents = C.listOf((Object[])subComponents);
        this.op = (LogicOperator)((Object)$.notNull((Object)((Object)operator)));
    }

    @Override
    public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
        WhereComponent first = this.subComponents.get(0);
        first.print(dialect, builder, paramId, entityAliasPrefix);
        int sz = this.subComponents.size();
        for (int i = 1; i < sz; ++i) {
            this.op.print(builder);
            this.subComponents.get(i).print(dialect, builder, paramId, entityAliasPrefix);
        }
    }

    private void printSubComponent(SqlDialect dialect, WhereComponent subComponent, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
        boolean subIsGroup = subComponent instanceof GroupWhereComponent;
        if (subIsGroup) {
            builder.append("(");
        }
        subComponent.print(dialect, builder, paramId, entityAliasPrefix);
        if (subIsGroup) {
            builder.append(")");
        }
    }
}

