/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.SQL;
import act.db.jpa.sql.SqlDialect;
import java.util.concurrent.atomic.AtomicInteger;

public enum Operator {
    EQ("=", "eq"),
    NE("<>", "ne", "neq"),
    NOT_NULL("not_null", new String[]{"notNull"}){

        @Override
        public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
            build.append(entityAliasPrefix).append(column).append(" IS NOT NULL");
        }
    }
    ,
    IS_NULL("is_null", new String[]{"isNull"}){

        @Override
        public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
            build.append(entityAliasPrefix).append(column).append(" IS NULL");
        }
    }
    ,
    LT("<", "lt", "lessThan", "less_than"),
    LTE("<=", "lte", "lessThanOrEqualTo", "less_than_or_equal_to"),
    GT(">", "gt", "greaterThan", "greater_than"),
    GTE(">=", "gte", "greaterThanOrEqualTo", "greater_than_or_equal_to"),
    BETWEEN("between", new String[0]){

        @Override
        public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
            build.append(entityAliasPrefix).append(column).append(" < ?").append(ordinalId.incrementAndGet()).append(" AND ").append(entityAliasPrefix).append(column).append(" > ?").append(ordinalId.incrementAndGet());
        }
    }
    ,
    LIKE("like", new String[0]){

        @Override
        public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
            build.append(entityAliasPrefix).append(column).append(" LIKE ?").append(ordinalId.incrementAndGet());
        }
    }
    ,
    ILIKE("ilike", new String[0]){

        @Override
        public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
            String fnLower = dialect.lowerCaseFunction();
            build.append(fnLower).append("(").append(entityAliasPrefix).append(column).append(") LIKE ").append(fnLower).append("(CONCAT('%', ?").append(ordinalId.incrementAndGet()).append(", '%'))");
        }
    };

    private String op;

    private Operator(String op, String ... aliases) {
        this.op = op;
        SQL.registerOperator(op, this);
        for (String alias : aliases) {
            SQL.registerOperator(alias, this);
        }
    }

    public void print(SqlDialect dialect, StringBuilder build, String column, AtomicInteger ordinalId, String entityAliasPrefix) {
        build.append(entityAliasPrefix).append(column).append(" ").append(this.op).append(" ?").append(ordinalId.incrementAndGet());
    }
}

