/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.SqlDialect;
import act.db.jpa.sql.SqlPart;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;

public class OrderByElement
implements SqlPart {
    private boolean descending;
    private String column;

    public OrderByElement(String column) {
        E.illegalArgumentIf((boolean)S.blank((String)column), (String)"column required");
        column = column.trim();
        if (column.startsWith("+")) {
            column = column.substring(1).trim();
        } else if (column.startsWith("-")) {
            column = column.substring(1).trim();
            this.descending = true;
        }
        if (column.contains(" ")) {
            S.List list = S.fastSplit((String)column, (String)" ");
            E.illegalArgumentIf((list.size() > 2 ? 1 : 0) != 0, (String)("Invalid order element: " + column));
            String dir = ((String)list.get(1)).toLowerCase();
            if ("desc".equals(dir)) {
                this.descending = true;
            } else if ("asc".equals(dir)) {
                this.descending = false;
            } else {
                throw new IllegalArgumentException("Unknown order dir in order element: " + column);
            }
            column = (String)list.get(0);
        }
        this.column = column;
    }

    public String column() {
        return this.column;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public int hashCode() {
        return $.hc((Object)this.column, (Object)this.descending);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByElement orderBy = (OrderByElement)o;
        return this.descending == orderBy.descending && $.eq((Object)this.column, (Object)orderBy.column);
    }

    public String toString() {
        return this.descending ? this.column + " DESC" : this.column;
    }

    @Override
    public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
        builder.append(entityAliasPrefix).append(this.column);
        if (this.descending) {
            builder.append(" DESC");
        }
    }

    OrderByElement descending() {
        this.descending = true;
        return this;
    }

    OrderByElement ascending() {
        this.descending = false;
        return this;
    }
}

