/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.OrderByElement;
import act.db.jpa.sql.SqlDialect;
import act.db.jpa.sql.SqlPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;

public class OrderByList
implements SqlPart {
    public static final OrderByList EMPTY_LIST = new OrderByList();
    private static final Logger LOGGER = LogManager.get(OrderByList.class);
    private static final String LEADING = "ORDER BY ";
    private static final int LEADING_LEN = "ORDER BY ".length();
    private List<OrderByElement> list = new ArrayList<OrderByElement>();
    private Map<String, Boolean> columns = new HashMap<String, Boolean>();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByList that = (OrderByList)o;
        return Objects.equals(this.list, that.list);
    }

    public int hashCode() {
        return $.hc(this.list);
    }

    public String toString() {
        int sz = this.list.size();
        switch (sz) {
            case 0: {
                return "";
            }
            case 1: {
                return LEADING + this.list.get(0).toString();
            }
        }
        S.Buffer buf = S.buffer((String)LEADING).append((Object)this.list.get(0));
        for (int i = 1; i < sz; ++i) {
            buf.append(",").append((Object)this.list.get(i));
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void print(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
        int sz = this.list.size();
        if (0 == sz) {
            return;
        }
        this.list.get(0).print(dialect, builder, paramId, entityAliasPrefix);
        for (int i = 1; i < sz; ++i) {
            builder.append(", ");
            this.list.get(i).print(dialect, builder, paramId, entityAliasPrefix);
        }
    }

    public void printWithLead(SqlDialect dialect, StringBuilder builder, AtomicInteger paramId, String entityAliasPrefix) {
        if (!this.isEmpty()) {
            builder.append(" ORDER BY ");
            this.print(dialect, builder, paramId, entityAliasPrefix);
        }
    }

    public OrderByList merge(OrderByList list) {
        OrderByList newList = new OrderByList();
        newList.columns.putAll(this.columns);
        newList.list.addAll(this.list);
        for (OrderByElement element : list.list) {
            newList.add(element);
        }
        return newList;
    }

    private void add(OrderByElement element) {
        String column = element.column();
        Boolean b = this.columns.get(column);
        if (null != b) {
            E.illegalArgumentIf((b.booleanValue() != element.isDescending() ? 1 : 0) != 0, (String)("conflict element:" + column));
            LOGGER.warn("duplicate element: " + column);
            return;
        }
        this.columns.put(column, element.isDescending());
        this.list.add(element);
    }

    public static OrderByList parse(String orderBy) {
        String[] sa;
        OrderByList list = new OrderByList();
        if (S.empty((String)(orderBy = orderBy.trim()))) {
            return list;
        }
        if (orderBy.toUpperCase().startsWith(LEADING)) {
            orderBy = orderBy.substring(LEADING_LEN);
        }
        for (String s : sa = orderBy.split(",")) {
            list.add(new OrderByElement(s));
        }
        return list;
    }
}

