/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.sql;

import act.db.jpa.sql.Action;
import act.db.jpa.sql.GroupWhereComponent;
import act.db.jpa.sql.LogicOperator;
import act.db.jpa.sql.Operator;
import act.db.jpa.sql.OrderByList;
import act.db.jpa.sql.SimpleWhereExpression;
import act.db.jpa.sql.SqlDialect;
import act.db.jpa.sql.WhereComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class SQL {
    private static final Logger LOGGER = LogManager.get(SQL.class);
    private String entityName;
    private String entityAliasPrefix;
    private Action action;
    private WhereComponent where;
    private OrderByList orderBy;
    private String rawSql;
    private static Map<String, Operator> operatorLookup = new HashMap<String, Operator>();

    private SQL(String entityName, Action action, WhereComponent where, OrderByList orderBy) {
        this.entityName = entityName;
        this.entityAliasPrefix = entityName.substring(0, 1) + ".";
        this.action = action;
        this.where = where;
        this.orderBy = orderBy;
    }

    private SQL(SQL copy) {
        this(copy.entityName, copy.action, copy.where, copy.orderBy);
    }

    private SQL(String rawSql) {
        this.rawSql = (String)$.notNull((Object)rawSql);
    }

    public SQL withOrderBy(String ... orderByList) {
        if (null == orderByList) {
            return this;
        }
        OrderByList list = Parser.parseOrderBy(orderByList);
        if (list.isEmpty()) {
            return this;
        }
        SQL sql = new SQL(this);
        sql.orderBy = null == sql.orderBy ? list : sql.orderBy.merge(list);
        return sql;
    }

    public String rawSql(SqlDialect dialect) {
        if (null == this.rawSql) {
            StringBuilder buf = new StringBuilder();
            AtomicInteger paramCounter = new AtomicInteger();
            this.action.print(dialect, buf, paramCounter, this.entityAliasPrefix);
            this.where.printWithLead(dialect, buf, paramCounter, this.entityAliasPrefix);
            this.orderBy.printWithLead(dialect, buf, paramCounter, this.entityAliasPrefix);
            this.rawSql = buf.toString();
        }
        return this.rawSql;
    }

    static void registerOperator(String key, Operator operator) {
        operatorLookup.put(key.toLowerCase(), operator);
    }

    public static class Parser {
        public static SQL parse(Type type, String entityName, String expression, String ... columns) {
            if (S.isBlank((String)expression)) {
                return type.startParsing(entityName, new String[0]).toSQL();
            }
            String lowerCase = expression.trim().toLowerCase();
            if (lowerCase.startsWith("select ") || lowerCase.startsWith("update ") || lowerCase.startsWith("delete ") || lowerCase.startsWith("from ")) {
                return new SQL(expression);
            }
            if (lowerCase.startsWith("order by ")) {
                Builder builder = new Builder().select(entityName, new String[0]);
                builder.orderBy = OrderByList.parse(expression.trim());
                return builder.toSQL();
            }
            Builder builder = type.startParsing(entityName, columns);
            return Parser.doParse(builder, expression).toSQL();
        }

        private static Builder doParse(Builder builder, String expression) {
            if (S.blank((String)expression)) {
                return builder;
            }
            Object list = expression.contains(" order by ") ? S.fastSplit((String)expression, (String)" order by ") : (expression.contains(" ORDER BY ") ? S.fastSplit((String)expression, (String)" ORDER BY ") : (expression.contains("OrderBy") ? S.fastSplit((String)expression, (String)"OrderBy") : (expression.contains(" ORDER_BY ") ? S.fastSplit((String)expression, (String)" ORDER_BY ") : (expression.contains(" Order By ") ? S.fastSplit((String)expression, (String)" Order By ") : C.list((Object)expression)))));
            WhereComponent where = Parser.parseWhere((String)list.get(0));
            OrderByList orderBy = OrderByList.EMPTY_LIST;
            int sz = list.size();
            if (sz > 1) {
                orderBy = Parser.parseOrderBy((String[])list.drop(0).toArray((Object[])new String[sz - 1]));
            }
            builder.where = where;
            builder.orderBy = orderBy;
            return builder;
        }

        private static OrderByList parseOrderBy(String ... orderList) {
            int sz = orderList.length;
            if (0 == sz) {
                return OrderByList.EMPTY_LIST;
            }
            OrderByList list = OrderByList.parse(orderList[0]);
            for (int i = 1; i < sz; ++i) {
                list = list.merge(OrderByList.parse(orderList[i]));
            }
            return list;
        }

        private static WhereComponent parseWhere(String whereClause) {
            if (S.empty((String)(whereClause = whereClause.trim()))) {
                return WhereComponent.EMPTY;
            }
            if (whereClause.matches("^by[A-Z].*$")) {
                return Parser.parsePlay1Where(whereClause);
            }
            return Parser.parseActWhere(whereClause);
        }

        private static WhereComponent parsePlay1Where(String whereClause) {
            whereClause = whereClause.substring(2);
            S.List parts = S.fastSplit((String)whereClause, (String)"And");
            return Parser.parseWhere((List<String>)parts);
        }

        private static WhereComponent parseActWhere(String whereClause) {
            C.List parts = C.listOf((Object[])whereClause.split("[,;:]+"));
            return Parser.parseWhere((List<String>)parts);
        }

        private static WhereComponent parseWhere(List<String> parts) {
            ArrayList<WhereComponent> list = new ArrayList<WhereComponent>();
            for (String part : parts) {
                WhereComponent comp = Parser.parseWhereComponent(part);
                if (WhereComponent.EMPTY == comp) continue;
                list.add(comp);
            }
            return new GroupWhereComponent(LogicOperator.AND, list);
        }

        private static WhereComponent parseWhereComponent(String part) {
            if (S.blank((String)part)) {
                return WhereComponent.EMPTY;
            }
            S.List tokens = S.fastSplit((String)part, (String)" ");
            String column = (String)tokens.get(0);
            int sz = tokens.size();
            if (1 == sz) {
                return new SimpleWhereExpression(column, Operator.EQ);
            }
            String s = (String)tokens.get(1);
            Operator op = (Operator)((Object)operatorLookup.get(s.toLowerCase()));
            E.illegalArgumentIf((null == op ? 1 : 0) != 0, (String)("Unknown operator: " + s));
            if (sz > 2) {
                LOGGER.warn("unused where clause tokens ignored: %s", new Object[]{S.string((Object)tokens.drop(2))});
            }
            return new SimpleWhereExpression(column, op);
        }
    }

    public static class Builder {
        private String entityName;
        private Action action;
        private WhereComponent where = WhereComponent.EMPTY;
        private OrderByList orderBy = OrderByList.EMPTY_LIST;

        public SQL toSQL() {
            return new SQL(this.entityName, this.action, this.where, this.orderBy);
        }

        public Builder select(String entityName, String ... columns) {
            this.ensureNoAction();
            this.action = new Action.Select(entityName, columns);
            this.entityName = entityName;
            return this;
        }

        public Builder count(String entityName) {
            this.ensureNoAction();
            this.action = new Action.Count(entityName);
            this.entityName = entityName;
            return this;
        }

        public Builder delete(String entityName) {
            this.ensureNoAction();
            this.action = new Action.Delete(entityName);
            this.entityName = entityName;
            return this;
        }

        public Builder update(String entityName, String ... columns) {
            this.ensureNoAction();
            this.action = new Action.Update(entityName, columns);
            this.entityName = entityName;
            return this;
        }

        private void ensureNoAction() {
            E.illegalArgumentIf((null != this.action ? 1 : 0) != 0, (String)"action already exists");
        }
    }

    public static enum Type {
        FIND{

            @Override
            protected Builder startParsing(String entity, String ... columns) {
                return new Builder().select(entity, columns);
            }
        }
        ,
        COUNT{

            @Override
            protected Builder startParsing(String entity, String ... columns) {
                return new Builder().count(entity);
            }
        }
        ,
        UPDATE{

            @Override
            protected Builder startParsing(String entity, String ... columns) {
                return new Builder().update(entity, columns);
            }
        }
        ,
        DELETE{

            @Override
            protected Builder startParsing(String entity, String ... columns) {
                return new Builder().delete(entity);
            }
        };


        protected abstract Builder startParsing(String var1, String ... var2);
    }
}

