/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.util;

import act.Act;
import act.app.App;
import act.db.DbManager;
import act.db.DbService;
import act.db.TimestampGenerator;
import act.db.meta.EntityClassMetaInfo;
import act.db.meta.EntityFieldMetaInfo;
import act.db.meta.EntityMetaInfoRepo;
import act.db.meta.MasterEntityMetaInfoRepo;
import act.util.Stateless;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.E;

@Stateless
public class TimestampAuditor {
    private Map<Class, Osgl.Visitor> createdAtLookup = new HashMap<Class, Osgl.Visitor>();
    private Map<Class, Osgl.Visitor> lastModifiedAtLookup = new HashMap<Class, Osgl.Visitor>();

    public TimestampAuditor() {
        this.buildLookups();
    }

    @PrePersist
    public void prePersist(Object entity) {
        Class<?> entityType = entity.getClass();
        TimestampAuditor.apply(this.createdAtLookup.get(entityType), entity);
        TimestampAuditor.apply(this.lastModifiedAtLookup.get(entityType), entity);
    }

    @PreUpdate
    public void preUpdate(Object entity) {
        Class<?> entityType = entity.getClass();
        TimestampAuditor.apply(this.lastModifiedAtLookup.get(entityType), entity);
    }

    private void buildLookups() {
        App app = Act.app();
        MasterEntityMetaInfoRepo masterRepo = app.entityMetaInfoRepo();
        DbManager dbManager = Act.dbManager();
        for (DbService db : app.dbServiceManager().registeredServices()) {
            EntityMetaInfoRepo repo = masterRepo.forDb(db.id());
            for (Class entityClass : repo.entityClasses()) {
                Field field;
                EntityClassMetaInfo classInfo = repo.classMetaInfo(entityClass);
                EntityFieldMetaInfo fieldInfo = classInfo.createdAtField();
                if (null != fieldInfo) {
                    field = (Field)$.notNull((Object)$.fieldOf((Class)entityClass, (String)fieldInfo.fieldName()));
                    field.setAccessible(true);
                    this.createdAtLookup.put(entityClass, new TimestampFieldVisitor(field, dbManager));
                }
                if (null == (fieldInfo = classInfo.lastModifiedAtField())) continue;
                field = (Field)$.notNull((Object)$.fieldOf((Class)entityClass, (String)fieldInfo.fieldName()));
                this.lastModifiedAtLookup.put(entityClass, new TimestampFieldVisitor(field, dbManager));
            }
        }
    }

    private static void apply(Osgl.Visitor visitor, Object entity) {
        if (null != visitor) {
            visitor.visit(entity);
        }
    }

    private static class TimestampFieldVisitor
    extends Osgl.Visitor {
        final TimestampGenerator tsGen;
        final Field field;

        public TimestampFieldVisitor(Field field, DbManager dbManager) {
            this.tsGen = dbManager.timestampGenerator(field.getType());
            field.setAccessible(true);
            this.field = field;
        }

        public void visit(Object entity) throws Osgl.Break {
            try {
                this.field.set(entity, this.tsGen.now());
            }
            catch (IllegalAccessException e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }
}

