/*
 * Decompiled with CFR 0.152.
 */
package act.db.jpa.util;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;

public class TimestampSetter<MODEL_TYPE>
extends Osgl.Visitor<MODEL_TYPE> {
    private Field timestampField;
    private Osgl.Func0 now;

    public TimestampSetter(Class<MODEL_TYPE> modelType, String timestampFieldName) {
        this.timestampField = $.fieldOf(modelType, (String)timestampFieldName);
        this.timestampField.setAccessible(true);
        Class<?> timestampType = this.timestampField.getType();
        if (Date.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return new Date($.ms());
                }
            };
        } else if (Time.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return new Time($.ms());
                }
            };
        } else if (Timestamp.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return new Timestamp($.ms());
                }
            };
        } else if (DateTime.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return DateTime.now();
                }
            };
        } else if (LocalDate.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return LocalDate.now();
                }
            };
        } else if (LocalTime.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return LocalTime.now();
                }
            };
        } else if (LocalDateTime.class.isAssignableFrom(timestampType)) {
            this.now = new Osgl.Func0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    return LocalDateTime.now();
                }
            };
        }
    }

    public void visit(MODEL_TYPE o) throws Osgl.Break {
        try {
            this.timestampField.set(o, this.now.apply());
        }
        catch (IllegalAccessException e) {
            throw E.unexpected((Throwable)e);
        }
    }
}

