/*
 * Decompiled with CFR 0.152.
 */
package org.actframework.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.actframework.maven.Runner;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class ActMojo
extends AbstractMojo {
    @Parameter(property="act.appEntry", defaultValue="${app.entry}", required=true, readonly=true)
    protected String appEntry;
    @Parameter(property="act.skip", defaultValue="false", required=true)
    protected boolean skip;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="act.jpdaPort", defaultValue="5005", required=true)
    private int jpdaPort;
    @Parameter(property="act.jvmArgs", required=false)
    private String jvmArgs;
    @Parameter(property="act.outputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private String buildOutputDirectory;
    @Parameter(property="act.useDefaultExcludes", defaultValue="true", required=true)
    protected boolean useDefaultExcludes;
    @Parameter(property="act.settleDownMillis", defaultValue="500", required=false)
    private Long settleDownMillis;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on. Will not execute.");
            return;
        }
        this.checkClasses(this.buildOutputDirectory);
        ArrayList<String> classpathItems = new ArrayList<String>();
        classpathItems.add(this.buildOutputDirectory);
        for (Artifact artifact : this.project.getArtifacts()) {
            classpathItems.add(artifact.getFile().toString());
        }
        this.startRunner(classpathItems);
    }

    private void startRunner(List<String> classpathItems) {
        Runner machine = this.createRunner(classpathItems);
        machine.start();
    }

    protected Runner createRunner(List<String> classpathItems) {
        return new Runner(this.appEntry, StringUtils.join(classpathItems, (String)File.pathSeparator), this.project.getBasedir(), this.jpdaPort, this.jvmArgs, this.e2e());
    }

    protected boolean e2e() {
        return false;
    }

    public void checkClasses(String classesDirectory) {
        if (!new File(classesDirectory).exists()) {
            this.getLog().error((CharSequence)("Directory with classes does not exist: " + classesDirectory));
            System.exit(1);
        }
    }
}

