/*
 * Decompiled with CFR 0.152.
 */
package org.actframework.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;

public class Runner {
    private static final Logger LOG = LogManager.get(Runner.class);
    private OutputStream outputStream = System.out;
    private StartedProcess startedProcess;
    private final String mainClass;
    private final String classpath;
    private final File mavenBaseDir;
    private final int jpdaPort;
    private final String jvmArgs;
    private final boolean e2e;

    public Runner(String mainClass, String classpath, File mavenBaseDir, int jpdaPort, String jvmArgs, boolean e2e) {
        this.mainClass = mainClass;
        this.classpath = classpath;
        this.mavenBaseDir = mavenBaseDir;
        this.jpdaPort = jpdaPort;
        this.jvmArgs = jvmArgs;
        this.e2e = e2e;
    }

    public OutputStream getOutput() {
        return this.outputStream;
    }

    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartedProcess getActiveProcess() {
        Runner runner = this;
        synchronized (runner) {
            return this.startedProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProcess(StartedProcess activeProcess) {
        Runner runner = this;
        synchronized (runner) {
            this.startedProcess = activeProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Runner runner = this;
        synchronized (runner) {
            try {
                if (this.startedProcess != null) {
                    this.startedProcess.getProcess().destroy();
                    this.startedProcess.getFuture().get();
                }
                this.startedProcess = this.startProcess();
                this.startedProcess.getProcess().waitFor();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                LOG.error("Something fishy happenend. Unable to cleanly restart!", new Object[]{e});
                LOG.error("You'll probably need to restart maven?");
            }
        }
    }

    private StartedProcess startProcess() throws IOException {
        ProcessExecutor processExecutor = this.buildProcessExecutor();
        return processExecutor.start();
    }

    private ProcessExecutor buildProcessExecutor() {
        ArrayList<String> commandLine = new ArrayList<String>();
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        commandLine.add(javaBin);
        if (this.jpdaPort > 0) {
            LOG.info("Listening for jpda connection at " + this.jpdaPort);
            commandLine.add("-Xdebug");
            commandLine.add(String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%s", this.jpdaPort));
        }
        if (StringUtils.isNotBlank((CharSequence)this.jvmArgs)) {
            S.List args = S.fastSplit((String)this.jvmArgs, (String)" ");
            for (String arg : args) {
                if (!S.notBlank((String)arg)) continue;
                commandLine.add(arg);
            }
        }
        if (this.e2e) {
            commandLine.add("-Dprofile=e2e");
        } else {
            commandLine.add("-Dapp.mode=dev");
        }
        commandLine.add("-cp");
        commandLine.add(this.classpath);
        commandLine.add(this.mainClass);
        return new ProcessExecutor(commandLine).directory(this.mavenBaseDir).destroyOnExit().redirectErrorStream(true).redirectOutput(this.outputStream);
    }
}

