/*
 * Decompiled with CFR 0.152.
 */
package act.social;

import act.Act;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgl.$;
import org.osgl.exception.UnexpectedIOException;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public class Config {
    public static final List<String> BUILT_IN_PROVIDERS = C.list((Object)"google", (Object[])new String[]{"facebook", "twitter", "yahoo", "linkedin", "foursquare"});
    private String provider;
    private String scope;
    private String authorizationUrl;
    private String requestTokenUrl;
    private String accessTokenUrl;
    private String profileUrl;
    private String key;
    private String secret;
    private String accessType;

    private Config() {
    }

    private Config(String provider) {
        this.provider = provider;
    }

    public Config(Config copy) {
        this.provider = copy.provider;
        this.scope = copy.scope;
        this.authorizationUrl = copy.authorizationUrl;
        this.requestTokenUrl = copy.requestTokenUrl;
        this.accessTokenUrl = copy.accessTokenUrl;
        this.profileUrl = copy.profileUrl;
        this.key = copy.key;
        this.secret = copy.secret;
        this.accessType = copy.accessType;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAuthUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public void setRequestTokenUrl(String requestTokenUrl) {
        this.requestTokenUrl = requestTokenUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String toString() {
        return "Config{provider='" + this.provider + '\'' + ", scope='" + this.scope + '\'' + ", authorizationUrl='" + this.authorizationUrl + '\'' + ", requestTokenUrl='" + this.requestTokenUrl + '\'' + ", accessTokenUrl='" + this.accessTokenUrl + '\'' + ", key='" + this.key + '\'' + ", secret='" + this.secret + '\'' + ", accessType='" + this.accessType + '\'' + '}';
    }

    private void populateFrom(Map properties) {
        for (Field field : Config.class.getDeclaredFields()) {
            String name = field.getName();
            String key = S.builder((String)"social_link.").append(this.provider).append(".").append(name).toString();
            String val = S.string(properties.get(key));
            if (!S.notBlank((String)val)) continue;
            $.setField((String)name, (Object)this, (Object)val);
        }
    }

    public static Config load(String provider) {
        return Default.get(provider);
    }

    public static void main(String[] args) {
        for (String providerId : BUILT_IN_PROVIDERS) {
            System.out.println(Default.get(providerId));
        }
    }

    private static class Default {
        private static Properties properties;
        private static Map<String, Config> defaults;

        private Default() {
        }

        static Config get(String providerId) {
            Config config = defaults.get(providerId);
            if (null == config) {
                config = Default.createFromProperties(providerId);
                defaults.put(providerId, config);
            }
            return new Config(config);
        }

        private static Config createFromProperties(String providerId) {
            Config config = new Config(providerId);
            config.populateFrom(Default.properties);
            config.populateFrom(Act.appConfig().rawConfiguration());
            return config;
        }

        static {
            try {
                properties = IO.loadProperties((InputStream)Config.class.getResourceAsStream("/social_link.properties"));
            }
            catch (NullPointerException e) {
                throw new UnexpectedIOException("Error loading default social link properties", new Object[0]);
            }
            defaults = new HashMap<String, Config>();
        }
    }
}

