/*
 * Decompiled with CFR 0.152.
 */
package act.social;

import act.app.ActionContext;
import act.app.conf.AutoConfig;
import act.controller.Controller;
import act.event.ActEvent;
import act.event.EventBus;
import act.social.SocialLinkFailed;
import act.social.SocialProfile;
import act.social.SocialProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.annotation.Action;
import org.osgl.mvc.annotation.GetAction;
import org.osgl.mvc.result.Result;
import org.osgl.util.Codec;
import org.osgl.util.Const;
import org.osgl.util.S;
import osgl.version.Version;

@AutoConfig(value="social_link")
@Controller(value="social")
public class SocialLink
extends Controller.Util {
    public static final Version VERSION = Version.of(SocialLink.class);
    public static final Const<String> LOGIN_REDIRECT = $.constant();

    @Action(value={"start"}, methods={H.Method.GET, H.Method.POST})
    public Result startSocialLink(SocialProvider provider, String callback, String payload, ActionContext context) {
        if (null == callback) {
            callback = context.req().referrer();
        }
        return SocialLink.redirect((String)provider.authUrl(callback, payload), (Object[])new Object[0]);
    }

    @GetAction(value={"auth_link"})
    public String socialRedirectLink(SocialProvider provider, String callback, String payload, ActionContext context) {
        if (null == callback) {
            callback = context.req().referrer();
        }
        return provider.authUrl(callback, payload);
    }

    @Action(value={"callback"}, methods={H.Method.GET, H.Method.POST})
    public Result authCallback(SocialProvider provider, String code, String state, EventBus eventBus) {
        String act_callback = null;
        String act_payload = null;
        if (S.notBlank((String)state)) {
            byte[] jsonStr = Codec.decodeUrlSafeBase64((String)state);
            JSONObject json = (JSONObject)JSON.parseObject((byte[])jsonStr, JSONObject.class, (Feature[])new Feature[0]);
            act_callback = json.getString("act_callback");
            act_payload = json.getString("act_payload");
        }
        try {
            provider.checkCsrfToken(state);
            SocialProfile profile = provider.doAuth(code, act_callback, act_payload);
            eventBus.trigger((ActEvent)profile.createFetchedEvent(act_payload, provider.getId()), new Object[0]);
        }
        catch (Result r) {
            return r;
        }
        catch (RuntimeException e) {
            eventBus.trigger((ActEvent)new SocialLinkFailed(), new Object[0]);
        }
        String originalCallback = act_callback;
        if (S.blank((String)originalCallback)) {
            originalCallback = (String)LOGIN_REDIRECT.get();
        }
        return SocialLink.redirect((String)originalCallback, (Object[])new Object[0]);
    }
}

