/*
 * Decompiled with CFR 0.152.
 */
package act.social;

import act.event.ActEvent;
import act.social.AuthenticationMethod;
import act.social.Config;
import act.social.SocialId;
import act.social.SocialProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

public class SocialProfile
implements Serializable {
    public static final String EVENT_FETCHED = "~social_profile_fetched~";
    private SocialId id;
    private String displayName;
    private String email;
    private String firstName;
    private String lastName;
    private String avatarUrl;
    private AuthenticationMethod authMethod;
    private transient Config serviceConfig;
    private String token;
    private long expiration;
    private String secret;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public SocialProfile() {
    }

    public SocialProfile(String userId, String provider) {
        this.id = new SocialId(userId, provider);
    }

    public SocialId getId() {
        return this.id;
    }

    public void setId(SocialId id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFullName() {
        S.Buffer buf = S.newBuffer();
        if (S.notBlank((String)this.firstName)) {
            buf.a(this.firstName);
            if (S.notBlank((String)this.lastName)) {
                buf.a(" ").append(this.lastName);
            }
        } else if (S.notBlank((String)this.lastName)) {
            buf.append(this.lastName);
        }
        return buf.toString();
    }

    public void setFullName(String fullName) {
        if (fullName.contains(" ")) {
            this.setFirstName(S.beforeLast((String)fullName, (String)" "));
            this.setLastName(S.afterLast((String)fullName, (String)" "));
        } else {
            this.setLastName(fullName);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public AuthenticationMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public Config getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(Config serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public boolean isTokenExpired() {
        return -1L != this.expiration && this.expiration < $.ms();
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public void putAll(Map<String, Object> data) {
        this.attributes.putAll(data);
    }

    public void put(String key, Object val) {
        this.attributes.put(key, val);
    }

    public Map<String, Object> getAttributes() {
        return C.newMap(this.attributes);
    }

    public <T> T get(String key) {
        return (T)this.attributes.get(key);
    }

    public void fillProfile(SocialProvider provider) {
        provider.fillProfile(this);
    }

    public Fetched createFetchedEvent(String payload, String provider) {
        return new Fetched(this, payload, provider);
    }

    public static class Fetched
    extends ActEvent<SocialProfile> {
        private String payload;
        private String provider;

        public Fetched(SocialProfile source, String payload, String provider) {
            super((Object)source);
            this.payload = payload;
            this.provider = provider;
        }

        public String provider() {
            return this.provider;
        }

        public String payload() {
            return this.payload;
        }
    }
}

