/*
 * Decompiled with CFR 0.152.
 */
package act.social;

import act.Act;
import act.social.AuthenticationMethod;
import act.social.Config;
import act.social.SocialProfile;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.osgl.inject.annotation.MapKey;
import org.osgl.inject.annotation.TypeOf;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class SocialProvider {
    protected final Logger logger = LogManager.get(SocialProvider.class);
    protected String id;
    protected Config config;
    protected AuthenticationMethod authMethod;
    protected String callbackUrl;
    OkHttpClient http = new OkHttpClient();

    public SocialProvider(String id, AuthenticationMethod authMethod) {
        this.id = id;
        this.authMethod = authMethod;
        this.config = Config.load(id);
        this.callbackUrl = Act.app().router().reverseRoute("act.social.SocialLink.authCallback", (Map)C.Map((Object[])new Object[]{"provider", this.getId()}), true);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public void checkCsrfToken(String csrfToken) {
    }

    public abstract SocialProfile doAuth(String var1, String var2, String var3);

    protected static StringBuilder appendParam(StringBuilder sb, String key, String val) {
        String sep = sb.toString().contains("?") ? "&" : "?";
        sb.append(sep).append(Codec.encodeUrl((String)key)).append("=").append(Codec.encodeUrl((String)val));
        return sb;
    }

    protected static StringBuilder appendParams(StringBuilder sb, Map<String, String> args) {
        String sep = sb.toString().contains("?") ? "&" : "?";
        sb.append(sep).append("zz=0");
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (null == val) continue;
            sb.append("&").append(key).append("=").append(Codec.encodeUrl((String)val));
        }
        return sb;
    }

    public abstract void fillProfile(SocialProfile var1);

    public abstract String authUrl(String var1, String var2);

    protected String callbackUrl() {
        return this.callbackUrl;
    }

    protected String readUrlAsString(String url, Map<String, String> params, boolean post) {
        Response resp = this.fetch(url, params, post);
        try {
            return resp.body().string();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    protected JSONObject readUrlAsJson(String url, Map<String, String> params, boolean post) {
        return JSON.parseObject((String)this.readUrlAsString(url, params, post));
    }

    protected Request finishBuildingRequest(Request.Builder builder, Map<String, String> params) {
        return builder.build();
    }

    private Response fetch(String url, Map<String, String> params, boolean post) {
        Request.Builder reqBuilder;
        if (post) {
            FormBody.Builder builder = new FormBody.Builder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.add(entry.getKey(), entry.getValue());
            }
            reqBuilder = new Request.Builder().url(url).post((RequestBody)builder.build());
        } else {
            url = SocialProvider.appendParams(S.builder((String)url), params).toString();
            reqBuilder = new Request.Builder().url(url).get();
        }
        Request req = this.finishBuildingRequest(reqBuilder, params);
        try {
            Response resp = this.http.newCall(req).execute();
            if (resp.isSuccessful()) {
                return resp;
            }
            throw E.unexpected((String)"Error reading url: %s", (Object[])new Object[]{resp.body().string()});
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Singleton
    public static class Resolver
    extends StringValueResolver<SocialProvider> {
        @Inject
        private Manager manager;

        public SocialProvider resolve(String s) {
            SocialProvider provider = this.manager.get(s);
            E.illegalArgumentIf((null == provider ? 1 : 0) != 0, (String)"Unknown provider: %s", (Object[])new Object[]{s});
            return provider;
        }
    }

    @Singleton
    public static class Manager {
        @TypeOf
        @MapKey(value="id")
        private Map<String, SocialProvider> providers;

        public SocialProvider get(String providerId) {
            return this.providers.get(providerId);
        }
    }
}

