/*
 * Decompiled with CFR 0.152.
 */
package act.social.provider;

import act.social.SocialId;
import act.social.SocialProfile;
import act.social.provider.OAuth2Provider;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class FacebookProvider
extends OAuth2Provider {
    public FacebookProvider() {
        super("facebook");
    }

    @Override
    public void fillProfile(SocialProfile user) {
        if (user.isTokenExpired()) {
            this.updateAccessToken(user);
        }
        String url = this.config.getProfileUrl();
        C.Map params = C.newMap((Object[])new Object[]{"fields", "name,picture,email,first_name,last_name", this.authMethod.accessTokenParamName(), user.getToken()});
        JSONObject json = this.readUrlAsJson(url, (Map<String, String>)params, false);
        user.setId(new SocialId(json.getString("id"), this.getId()));
        user.setFirstName(json.getString("first_name"));
        user.setLastName(json.getString("last_name"));
        user.setEmail(json.getString("email"));
        Object pic = json.get((Object)"picture");
        if (pic instanceof JSONObject) {
            user.setAvatarUrl(((JSONObject)pic).getJSONObject("data").getString("url"));
        } else if (null != pic) {
            user.setAvatarUrl(S.string((Object)pic));
        }
    }

    @Override
    protected boolean accessTokenInJson() {
        return true;
    }

    @Override
    protected String expiresParamName() {
        return "expires_in";
    }

    private void updateAccessToken(SocialProfile user) {
        throw E.tbd();
    }
}

