/*
 * Decompiled with CFR 0.152.
 */
package act.social.provider;

import act.social.SocialId;
import act.social.SocialProfile;
import act.social.provider.OAuth2Provider;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;

public class GoogleProvider
extends OAuth2Provider {
    public GoogleProvider() {
        super("google");
    }

    @Override
    protected Map<String, String> exchangeAccessTokenParams(String code, String callback, String payload) {
        Map<String, String> params = super.exchangeAccessTokenParams(code, callback, payload);
        params.put("grant_type", "authorization_code");
        return params;
    }

    @Override
    protected boolean postToAccessTokenUrl() {
        return true;
    }

    @Override
    protected boolean accessTokenInJson() {
        return true;
    }

    @Override
    protected String expiresParamName() {
        return "expires_in";
    }

    @Override
    protected long parseExpires(String s) {
        return $.ms() + Long.parseLong(s) * 1000L - 5000L;
    }

    @Override
    public void fillProfile(SocialProfile user) {
        if (user.isTokenExpired()) {
            this.updateAccessToken(user);
        }
        String url = this.config.getProfileUrl();
        C.Map params = C.Map((Object[])new Object[]{"fields", "emails/value,id,image/url,name(familyName,givenName)", this.authMethod.accessTokenParamName(), user.getToken()});
        JSONObject json = this.readUrlAsJson(url, (Map<String, String>)params, false);
        user.setId(new SocialId(json.getString("id"), this.getId()));
        JSONObject name = json.getJSONObject("name");
        user.setFirstName(name.getString("givenName"));
        user.setLastName(name.getString("familyName"));
        user.setEmail(json.getJSONArray("emails").getJSONObject(0).getString("value"));
        user.setAvatarUrl(json.getJSONObject("image").getString("url"));
    }

    private void updateAccessToken(SocialProfile user) {
        throw E.tbd();
    }
}

