/*
 * Decompiled with CFR 0.152.
 */
package act.social.provider;

import act.social.SocialId;
import act.social.SocialProfile;
import act.social.provider.OAuth2Provider;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class LinkedInProvider
extends OAuth2Provider {
    public LinkedInProvider() {
        super("linkedin");
    }

    @Override
    protected String expiresParamName() {
        return "expires_in";
    }

    @Override
    protected long parseExpires(String s) {
        return $.ms() + Long.parseLong(s) * 1000L - 5000L;
    }

    @Override
    protected boolean accessTokenInJson() {
        return true;
    }

    @Override
    protected String accessTokenHeaderName() {
        return "Authorization";
    }

    @Override
    protected String accessTokenHeaderVal(String token) {
        return S.builder((String)"Bearer ").append(token).toString();
    }

    @Override
    public void fillProfile(SocialProfile user) {
        if (user.isTokenExpired()) {
            this.updateAccessToken(user);
        }
        String url = this.config.getProfileUrl();
        C.Map params = C.newMap((Object[])new Object[]{"format", "json", this.authMethod.accessTokenParamName(), user.getToken()});
        JSONObject json = this.readUrlAsJson(url, (Map<String, String>)params, false);
        user.setId(new SocialId(json.getString("id"), this.getId()));
        user.setFirstName(json.getString("firstName"));
        user.setLastName(json.getString("lastName"));
        user.setEmail(json.getString("emailAddress"));
        user.setAvatarUrl(json.getString("pictureUrl"));
    }

    private void updateAccessToken(SocialProfile user) {
        throw E.tbd();
    }
}

