/*
 * Decompiled with CFR 0.152.
 */
package act.social.provider;

import act.social.AuthenticationMethod;
import act.social.SocialProfile;
import act.social.SocialProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import okhttp3.Request;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.Codec;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class OAuth2Provider
extends SocialProvider {
    public OAuth2Provider(String id) {
        super(id, AuthenticationMethod.OAUTH2);
    }

    protected boolean postToAccessTokenUrl() {
        return false;
    }

    protected Map<String, String> authorizationParams(String callback, String payload) {
        return C.Map((Object[])new Object[]{this.authMethod.keyParamName(), this.config.getKey(), this.authMethod.callBackUrlParamName(), this.callbackUrl(), this.authMethod.scopeParamName(), this.config.getScope(), this.authMethod.csrfTokenParamName(), this.createCsrfToken(), "state", this.state(callback, payload), "response_type", "code"});
    }

    protected Map<String, String> exchangeAccessTokenParams(String code, String callback, String payload) {
        return C.newMap((Object[])new Object[]{this.authMethod.keyParamName(), this.config.getKey(), this.authMethod.secretParamName(), this.config.getSecret(), this.authMethod.authCodeParamName(), code, this.authMethod.callBackUrlParamName(), this.callbackUrl(), "state", this.state(callback, payload), "grant_type", "authorization_code"});
    }

    @Override
    public String authUrl(String callback, String payload) {
        String url = this.config.getAuthUrl();
        StringBuilder sb = S.builder((String)url);
        OAuth2Provider.appendParams(sb, this.authorizationParams(callback, payload));
        return sb.toString();
    }

    protected String expiresParamName() {
        return "expires";
    }

    protected long parseExpires(String s) {
        return $.ms() + Long.parseLong(s) - 5000L;
    }

    protected String accessTokenHeaderName() {
        return null;
    }

    protected String accessTokenHeaderVal(String token) {
        return token;
    }

    protected String accessTokenParamName() {
        return this.authMethod.accessTokenParamName();
    }

    @Override
    protected Request finishBuildingRequest(Request.Builder builder, Map<String, String> params) {
        this.tryApplyAccessToken(builder, params);
        return builder.build();
    }

    protected final void tryApplyAccessToken(Request.Builder builder, Map<String, String> params) {
        String accessToken = params.get(this.accessTokenParamName());
        if (null == accessToken) {
            return;
        }
        String headerName = this.accessTokenHeaderName();
        if (null != headerName) {
            builder.addHeader(headerName, this.accessTokenHeaderVal(accessToken));
            params.remove(this.accessTokenParamName());
        }
    }

    protected boolean accessTokenInJson() {
        return false;
    }

    @Override
    public SocialProfile doAuth(String code, String act_callback, String act_payload) {
        String result;
        String accessToken = null;
        long expires = -1L;
        if (!this.accessTokenInJson()) {
            String[] pairs;
            result = this.readUrlAsString(this.config.getAccessTokenUrl(), this.exchangeAccessTokenParams(code, act_callback, act_payload), this.postToAccessTokenUrl());
            for (String pair : pairs = result.split("&")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                String k = kv[0];
                if ("access_token".equals(k)) {
                    accessToken = kv[1];
                    continue;
                }
                if (!this.expiresParamName().equals(k)) continue;
                expires = this.parseExpires(kv[1]);
            }
        } else {
            result = this.readUrlAsJson(this.config.getAccessTokenUrl(), this.exchangeAccessTokenParams(code, act_callback, act_payload), this.postToAccessTokenUrl());
            accessToken = result.getString("access_token");
            expires = this.parseExpires(result.getString(this.expiresParamName()));
        }
        SocialProfile profile = new SocialProfile();
        profile.setToken(accessToken);
        profile.setExpiration(expires);
        this.fillProfile(profile);
        return profile;
    }

    private String createCsrfToken() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }

    private void updateAccessToken(SocialProfile user) {
        throw E.tbd();
    }

    private String state(String callback, String payload) {
        JSONObject state = new JSONObject();
        if (S.notBlank((String)callback)) {
            state.put("act_callback", (Object)callback);
        }
        if (S.notBlank((String)payload)) {
            state.put("act_payload", (Object)callback);
        }
        return Codec.encodeUrlSafeBase64((byte[])JSON.toJSONBytes((Object)state, (SerializerFeature[])new SerializerFeature[0]));
    }
}

