/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.FieldVisitor;
import act.asm.Type;
import act.storage.StorageServiceManager;
import act.storage.db.DbHooker;
import act.util.AppByteCodeEnhancer;
import act.util.AsmTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.util.C;
import org.osgl.util.S;

public class EntityClassEnhancer
extends AppByteCodeEnhancer<EntityClassEnhancer> {
    private boolean hasManagedFields = false;
    private String cn;
    private volatile StorageServiceManager ssm;
    private List<DbHooker> dbHookers = C.list();
    private Map<DbHooker, Set<String>> transientAnnotationState = C.newMap((Object[])new Object[0]);
    private List<String> managedFields = C.newList();

    public EntityClassEnhancer() {
        super(S.F.startsWith((String)"act.").negate());
    }

    protected Class<EntityClassEnhancer> subClass() {
        return EntityClassEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        String className = name.replace('/', '.').replace('$', '.');
        List<String> l = this.ssm().managedFields(className);
        boolean bl = this.hasManagedFields = !l.isEmpty();
        if (this.hasManagedFields) {
            this.cn = className;
            this.dbHookers = this.ssm().dbHookers();
            this.managedFields = l;
            for (DbHooker hooker : this.dbHookers) {
                this.transientAnnotationState.put(hooker, (Set<String>)C.newSet());
            }
        }
    }

    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        if (this.managedFields.contains(name)) {
            return new FieldVisitor(327680, fv){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    for (DbHooker hooker : EntityClassEnhancer.this.dbHookers) {
                        Type transientType = Type.getType((Class)hooker.transientAnnotationType());
                        if (!transientType.equals((Object)Type.getType((String)desc))) continue;
                        Set set = (Set)EntityClassEnhancer.this.transientAnnotationState.get(hooker);
                        set.add(name);
                    }
                    return super.visitAnnotation(desc, visible);
                }

                public void visitEnd() {
                    if (EntityClassEnhancer.this.shouldEnhance()) {
                        for (DbHooker hooker : EntityClassEnhancer.this.dbHookers) {
                            if (((Set)EntityClassEnhancer.this.transientAnnotationState.get(hooker)).contains(name)) continue;
                            AnnotationVisitor av = this.fv.visitAnnotation(Type.getType((Class)hooker.transientAnnotationType()).getDescriptor(), true);
                            av.visitEnd();
                        }
                    }
                    super.visitEnd();
                }
            };
        }
        return fv;
    }

    public void visitEnd() {
        StorageServiceManager ssm = this.ssm();
        if (this.shouldEnhance()) {
            HashMap<String, FieldVisitor> fvMap = new HashMap<String, FieldVisitor>();
            for (DbHooker hooker : this.dbHookers) {
                for (String fn : ssm.managedFields(this.cn)) {
                    FieldVisitor fv = (FieldVisitor)fvMap.get(fn);
                    boolean isCollection = ssm.isCollection(this.cn, fn);
                    FieldVisitor fv0 = this.doEnhanceOn(fn, hooker, isCollection, fv);
                    if (null != fv) continue;
                    fvMap.put(fn, fv0);
                }
            }
            for (FieldVisitor fv : fvMap.values()) {
                fv.visitEnd();
            }
        }
        super.visitEnd();
    }

    private FieldVisitor doEnhanceOn(String sobjField, DbHooker hooker, boolean isCollection, FieldVisitor fv) {
        return this.addKeyField(sobjField, isCollection, hooker, fv);
    }

    private FieldVisitor addKeyField(String sobjField, boolean isCollection, DbHooker hooker, FieldVisitor fv) {
        String fieldName = S.builder((String)sobjField).append("Key").toString();
        String desc = isCollection ? "Ljava/util/Set;" : AsmTypes.STRING_DESC;
        String signature = isCollection ? "Ljava/util/Set<Ljava/lang/String;>;" : null;
        fv = null == fv ? this.cv.visitField(2, fieldName, desc, signature, null) : fv;
        AnnotationVisitor av = fv.visitAnnotation(Type.getType((Class)hooker.transientAnnotationType()).getDescriptor(), true);
        av.visitEnd();
        return fv;
    }

    private boolean shouldEnhance() {
        return this.hasManagedFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageServiceManager ssm() {
        if (null == this.ssm) {
            EntityClassEnhancer entityClassEnhancer = this;
            synchronized (entityClassEnhancer) {
                if (null == this.ssm) {
                    this.ssm = (StorageServiceManager)((Object)App.instance().singleton(StorageServiceManager.class));
                }
            }
        }
        return this.ssm;
    }
}

