/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.app.App;
import act.handler.RequestHandler;
import act.handler.builtin.StaticFileGetter;
import act.route.RouteSource;
import act.storage.StoragePlugin;
import act.util.UploadFileStorageService;
import java.io.File;
import java.util.Map;
import org.osgl.http.H;
import org.osgl.storage.IStorageService;
import org.osgl.storage.impl.FileSystemService;
import org.osgl.util.S;

public class FileSystemStoragePlugin
extends StoragePlugin {
    @Override
    protected IStorageService initStorageService(String id, App app, Map<String, String> conf) {
        conf = FileSystemStoragePlugin.calibrate(conf, "storage.fs.");
        FileSystemService ss = new FileSystemService(conf);
        ss.setKeyNameProvider(UploadFileStorageService.ACT_STORAGE_KEY_NAME_PROVIDER);
        String home = conf.get("storage.fs.home.dir");
        String url = ss.getStaticWebEndpoint();
        if (null != url) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if (S.notBlank((String)url) && !url.startsWith("http") && !url.startsWith("//")) {
                App.instance().router().addMapping(H.Method.GET, (CharSequence)url, (RequestHandler)new StaticFileGetter(new File(home)), RouteSource.BUILD_IN);
            }
        }
        return ss;
    }
}

