/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.ActComponent;
import act.app.App;
import act.app.AppByteCodeScanner;
import act.app.AppByteCodeScannerBase;
import act.app.AppSourceCodeScanner;
import act.asm.AnnotationVisitor;
import act.asm.FieldVisitor;
import act.asm.Type;
import act.storage.StorageServiceManager;
import act.storage.Store;
import act.storage.UpdatePolicy;
import act.util.AppCodeScannerPluginBase;
import act.util.ByteCodeVisitor;
import java.util.Set;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.S;

@ActComponent
public class SObjectFieldScanner
extends AppCodeScannerPluginBase {
    public AppSourceCodeScanner createAppSourceCodeScanner(App app) {
        return null;
    }

    public AppByteCodeScanner createAppByteCodeScanner(App app) {
        return new _AppByteCodeScanner(app);
    }

    public boolean load() {
        return true;
    }

    private static class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private App app;
        private boolean managed;
        private String className;
        private String serviceId;
        private String contextPath;
        private UpdatePolicy updatePolicy = UpdatePolicy.DELETE_OLD_DATA;
        private static final Set<String> SUPPORTED_STORE_FIELD_DESCS = C.set((Object)"Lorg/osgl/storage/ISObject;", (Object[])new String[]{"Lorg/osgl/storage/impl/SObject;"});
        private static final Set<String> SUPPORTED_STORE_FIELD_SIGNATURES = C.set((Object)"Ljava/util/List<Lorg/osgl/storage/ISObject;>;", (Object[])new String[]{"Ljava/util/List<Lorg/osgl/storage/SObject;>;", "Ljava/util/Set<Lorg/osgl/storage/ISObject;>;", "Ljava/util/Set<Lorg/osgl/storage/SObject;>;"});

        _ByteCodeVisitor(App app) {
            this.app = (App)$.notNull((Object)app);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (this.isStoreAnno(desc)) {
                this.managed = true;
                return new AnnotationVisitor(327680, av){

                    public void visit(String name, Object value) {
                        if ("value".equals(name)) {
                            String contextPath;
                            String serviceId;
                            String url = S.string((Object)value);
                            if (url.contains(":")) {
                                serviceId = S.beforeFirst((String)url, (String)":");
                                contextPath = S.afterFirst((String)url, (String)":");
                            } else {
                                serviceId = null;
                                contextPath = url;
                            }
                            _ByteCodeVisitor.this.serviceId = serviceId;
                            _ByteCodeVisitor.this.contextPath = contextPath;
                        }
                    }

                    public void visitEnum(String name, String desc, String value) {
                        super.visitEnum(name, desc, value);
                        if ("updatePolicy".equals(name)) {
                            _ByteCodeVisitor.this.updatePolicy = UpdatePolicy.valueOf(value);
                        }
                    }
                };
            }
            return av;
        }

        public void visitEnd() {
            super.visitEnd();
            if (this.managed) {
                this.storageServiceManager().registerServiceIndex(this.className, null, false, this.serviceId, this.contextPath, this.updatePolicy);
            }
        }

        private static boolean isSObjectField(String desc, String signature) {
            if (null != signature) {
                return SUPPORTED_STORE_FIELD_SIGNATURES.contains(signature);
            }
            return SUPPORTED_STORE_FIELD_DESCS.contains(desc);
        }

        public FieldVisitor visitField(int access, String name, String desc, final String signature, Object value) {
            boolean isStatic;
            FieldVisitor fv = super.visitField(access, name, desc, signature, value);
            boolean bl = isStatic = (access & 8) != 0;
            if (isStatic) {
                return fv;
            }
            if (_ByteCodeVisitor.isSObjectField(desc, signature)) {
                final String fieldName = name;
                return new FieldVisitor(327680, fv){
                    private String serviceId;
                    private String contextPath;
                    private boolean managed;
                    private UpdatePolicy updatePolicy;
                    private boolean isCollection;
                    {
                        super(arg0, arg1);
                        this.serviceId = "default";
                        this.contextPath = "";
                        this.managed = false;
                        this.updatePolicy = UpdatePolicy.DELETE_OLD_DATA;
                        this.isCollection = null != signature;
                    }

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        AnnotationVisitor av = super.visitAnnotation(desc, visible);
                        if (_ByteCodeVisitor.this.isStoreAnno(desc)) {
                            this.managed = true;
                            return new AnnotationVisitor(327680, av){

                                public void visit(String name, Object value) {
                                    if ("value".equals(name)) {
                                        String url = S.string((Object)value);
                                        if (url.contains(":")) {
                                            serviceId = S.beforeFirst((String)url, (String)":");
                                            contextPath = S.afterFirst((String)url, (String)":");
                                        } else {
                                            serviceId = null;
                                            contextPath = url;
                                        }
                                    }
                                }

                                public void visitEnum(String name, String desc, String value) {
                                    super.visitEnum(name, desc, value);
                                    if ("updatePolicy".equals(name)) {
                                        updatePolicy = UpdatePolicy.valueOf(value);
                                    }
                                }
                            };
                        }
                        return av;
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        if (this.managed) {
                            if (S.blank((String)this.serviceId)) {
                                this.serviceId = _ByteCodeVisitor.this.serviceId;
                            }
                            if (S.blank((String)this.contextPath)) {
                                this.contextPath = _ByteCodeVisitor.this.contextPath;
                            }
                            _ByteCodeVisitor.this.storageServiceManager().registerServiceIndex(_ByteCodeVisitor.this.className, fieldName, this.isCollection, this.serviceId, this.contextPath, this.updatePolicy);
                        }
                    }
                };
            }
            return fv;
        }

        private boolean isStoreAnno(String desc) {
            return Type.getType(Store.class).equals((Object)Type.getType((String)desc));
        }

        private StorageServiceManager storageServiceManager() {
            return (StorageServiceManager)((Object)this.app.singleton(StorageServiceManager.class));
        }
    }

    private static class _AppByteCodeScanner
    extends AppByteCodeScannerBase {
        private App app;

        _AppByteCodeScanner(App app) {
            this.app = (App)$.notNull((Object)app);
        }

        protected boolean shouldScan(String className) {
            return true;
        }

        public ByteCodeVisitor byteCodeVisitor() {
            return new _ByteCodeVisitor(this.app);
        }

        public void scanFinished(String className) {
        }
    }
}

