/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.Act;
import act.Destroyable;
import act.plugin.Plugin;
import act.storage.StoragePlugin;
import act.util.DestroyableBase;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.util.C;

public class StoragePluginManager
extends DestroyableBase
implements Plugin {
    private Map<String, StoragePlugin> plugins = C.newMap((Object[])new Object[0]);
    private static Set<StoragePlugin> pendingStoragePlugins = C.newSet();

    protected void releaseResources() {
        super.releaseResources();
        Destroyable.Util.tryDestroyAll(this.plugins.values(), ApplicationScoped.class);
        this.plugins.clear();
    }

    public void register() {
        Act.registerPlugin((Plugin)this);
        for (StoragePlugin storagePlugin : pendingStoragePlugins) {
            this.register(storagePlugin);
        }
        pendingStoragePlugins.clear();
    }

    public synchronized void register(StoragePlugin storagePlugin) {
        this.plugins.put(((Object)((Object)storagePlugin)).getClass().getCanonicalName().intern(), storagePlugin);
    }

    public synchronized StoragePlugin plugin(String type) {
        return this.plugins.get(type);
    }

    public boolean hasPlugin() {
        return !this.plugins.isEmpty();
    }

    public synchronized StoragePlugin theSolePlugin() {
        if (this.plugins.size() == 1) {
            return this.plugins.values().iterator().next();
        }
        return null;
    }

    public static void deplayedRegister(StoragePlugin storagePlugin) {
        StoragePluginManager manager = StoragePluginManager.instance();
        if (null == manager) {
            pendingStoragePlugins.add(storagePlugin);
        } else {
            manager.register(storagePlugin);
        }
    }

    public static StoragePluginManager instance() {
        return (StoragePluginManager)Act.registeredPlugin(StoragePluginManager.class);
    }
}

