/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.app.App;
import act.cli.Command;
import act.storage.StorageServiceManager;
import act.storage.UpdatePolicy;
import act.util.PropertySpec;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.S;

public class StorageServiceAdmin {
    private StorageServiceManager ssm;

    @Inject
    public StorageServiceAdmin(App app) {
        this.ssm = (StorageServiceManager)((Object)app.singleton(StorageServiceManager.class));
    }

    @Command(value="act.ss.list, act.ss.print", help="List all storage field info")
    @PropertySpec(value={"className,fieldName,updatePolicy,serviceId,contextPath"})
    public Collection<FieldServiceInfo> listSObjectFields() {
        Set<String> fields = this.ssm.storageFields();
        C.List l = C.newList();
        for (String s : fields) {
            l.add((Object)new FieldServiceInfo(s));
        }
        return l.sorted();
    }

    public class FieldServiceInfo
    implements Comparable<FieldServiceInfo> {
        private String className;
        private String fieldName;
        private UpdatePolicy updatePolicy;
        private IStorageService ss;

        public FieldServiceInfo(String classField) {
            this.className = S.before((String)classField, (String)":");
            this.fieldName = S.after((String)classField, (String)":");
            this.ss = StorageServiceAdmin.this.ssm.storageService(this.className, this.fieldName);
            this.updatePolicy = StorageServiceAdmin.this.ssm.updatePolicy(this.className, this.fieldName);
        }

        public String getClassName() {
            return this.className;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getServiceId() {
            return this.ss.id();
        }

        public String getContextPath() {
            return this.ss.getContextPath();
        }

        public UpdatePolicy getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        public int compareTo(FieldServiceInfo o) {
            int n = o.className.compareTo(this.className);
            return 0 != n ? n : o.fieldName.compareTo(this.fieldName);
        }
    }
}

