/*
 * Decompiled with CFR 0.152.
 */
package act.storage;

import act.Destroyable;
import act.app.App;
import act.app.AppService;
import act.app.event.AppEventId;
import act.conf.AppConfig;
import act.event.ActEvent;
import act.inject.DependencyInjectionBinder;
import act.plugin.AppServicePlugin;
import act.storage.StoragePlugin;
import act.storage.StoragePluginManager;
import act.storage.StorageServiceManagerInitialized;
import act.storage.UpdatePolicy;
import act.storage.db.DbHooker;
import act.storage.db.util.Setter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.ConfigurationException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@Singleton
public class StorageServiceManager
extends AppServicePlugin
implements AppService<StorageServiceManager>,
Destroyable {
    private static Logger logger = LogManager.get(StorageServiceManager.class);
    public static final String DEFAULT = "default";
    private Map<String, IStorageService> serviceById = C.newMap((Object[])new Object[0]);
    private Map<String, IStorageService> serviceByClassField = C.newMap((Object[])new Object[0]);
    private Map<String, Boolean> fieldTypeMap = C.newMap((Object[])new Object[0]);
    private Map<Osgl.T2<Class, String>, Osgl.Val<IStorageService>> serviceByClass = C.newMap((Object[])new Object[0]);
    private Map<String, UpdatePolicy> updatePolicyByClassField = C.newMap((Object[])new Object[0]);
    private Map<Osgl.T2<Class, String>, Osgl.Val<UpdatePolicy>> updatePolicyByClass = C.newMap((Object[])new Object[0]);
    private Map<String, List<String>> managedFieldByClass = C.newMap((Object[])new Object[0]);
    private Map<String, List<String>> managedFieldByClass2 = C.newMap((Object[])new Object[0]);
    private Map<Osgl.T2<Class, String>, Setter> setterByClass = C.newMap((Object[])new Object[0]);
    private List<DbHooker> dbHookers = C.newList();
    private App app;
    private boolean isDestroyed;

    protected void applyTo(App app) {
        this.reset();
        this.app = app;
        this.initServices(app.config());
        app.registerSingleton((Object)this);
        app.jobManager().on(AppEventId.DEPENDENCY_INJECTOR_LOADED, new Runnable(){

            @Override
            public void run() {
                StorageServiceManager.this.app().eventBus().emit((ActEvent)new DependencyInjectionBinder<StorageServiceManager>((Object)this, StorageServiceManager.class){

                    public StorageServiceManager resolve(App app) {
                        return StorageServiceManager.this;
                    }
                });
            }
        });
        app.eventBus().emit((ActEvent)new StorageServiceManagerInitialized(this));
    }

    public Class<? extends Annotation> scope() {
        return ApplicationScoped.class;
    }

    private void reset() {
        this.isDestroyed = false;
    }

    private static String ssKey(String className, String fieldName) {
        StringBuilder sb = S.builder();
        sb.append((String)$.notNull((Object)className));
        if (S.notBlank((String)fieldName)) {
            sb.append(":");
            sb.append(fieldName);
        }
        return sb.toString();
    }

    public void registerServiceIndex(String className, String fieldName, boolean isCollection, String serviceId, String contextPath, UpdatePolicy updatePolicy) {
        IStorageService ss;
        if (S.blank((String)serviceId)) {
            serviceId = DEFAULT;
        }
        if (null == (ss = this.serviceById.get(serviceId))) {
            if (DEFAULT.equals(serviceId)) {
                logger.warn("default storage service not configured. Use the upload storage service");
                ss = this.app().uploadFileStorageService();
            } else {
                throw E.invalidConfiguration((String)"Cannot find storage engine by id: %s", (Object[])new Object[]{serviceId});
            }
        }
        assert (null != ss);
        if (S.notBlank((String)contextPath)) {
            ss = ss.subFolder(contextPath);
        }
        String key = StorageServiceManager.ssKey(className, fieldName);
        this.serviceByClassField.put(key, ss);
        this.fieldTypeMap.put(key, isCollection);
        if (null != updatePolicy) {
            this.updatePolicyByClassField.put(key, updatePolicy);
        }
    }

    public boolean isCollection(String className, String fieldName) {
        String key = StorageServiceManager.ssKey(className, fieldName);
        Boolean b = this.fieldTypeMap.get(key);
        return null == b ? false : b;
    }

    public Set<String> storageFields() {
        return this.serviceByClassField.keySet();
    }

    public IStorageService storageService(String className, String fieldName) {
        String key = StorageServiceManager.ssKey(className, fieldName);
        IStorageService svc = this.serviceByClassField.get(key);
        if (null == svc) {
            svc = this.serviceByClassField.get(className);
        }
        if (null == svc) {
            svc = this.app().uploadFileStorageService();
        }
        return svc;
    }

    public IStorageService storageService(Class c, String fieldName) {
        Osgl.T2 key = $.T2((Object)c, (Object)fieldName);
        Osgl.Val val = this.serviceByClass.get(key);
        if (null == val) {
            while (Object.class != c) {
                IStorageService ss = this.serviceByClassField.get(StorageServiceManager.ssKey(c.getName(), fieldName));
                if (null == ss) {
                    ss = this.serviceByClassField.get(c.getName());
                }
                if (null == ss) {
                    c = c.getSuperclass();
                    continue;
                }
                val = $.val((Object)ss);
                this.serviceByClass.put((Osgl.T2<Class, String>)key, (Osgl.Val<IStorageService>)val);
                return ss;
            }
            val = $.val(null);
            this.serviceByClass.put((Osgl.T2<Class, String>)key, (Osgl.Val<IStorageService>)val);
        }
        return (IStorageService)val.get();
    }

    public IStorageService storageService(String serviceId) {
        return this.serviceById.get(serviceId);
    }

    public UpdatePolicy updatePolicy(String className, String fieldName) {
        return this.updatePolicyByClassField.get(StorageServiceManager.ssKey(className, fieldName));
    }

    public UpdatePolicy updatePolicy(Class c, String fieldName) {
        Osgl.T2 key = $.T2((Object)c, (Object)fieldName);
        Osgl.Val v = this.updatePolicyByClass.get(key);
        if (null == v) {
            while (Object.class != c) {
                UpdatePolicy p = this.updatePolicy(c.getName(), fieldName);
                if (null != p) {
                    this.updatePolicyByClass.put((Osgl.T2<Class, String>)key, (Osgl.Val<UpdatePolicy>)$.val((Object)((Object)p)));
                    return p;
                }
                c = c.getSuperclass();
            }
            v = $.val((Object)((Object)((UpdatePolicy)null)));
            this.updatePolicyByClass.put((Osgl.T2<Class, String>)key, (Osgl.Val<UpdatePolicy>)v);
        }
        return (UpdatePolicy)((Object)v.get());
    }

    public StorageServiceManager app(App app) {
        this.app = app;
        return this;
    }

    public App app() {
        return this.app;
    }

    public boolean isDestroyed() {
        return this.isDestroyed;
    }

    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this.isDestroyed = true;
        Destroyable.Util.tryDestroyAll(this.serviceById.values(), ApplicationScoped.class);
        Destroyable.Util.tryDestroyAll(this.dbHookers, ApplicationScoped.class);
        this.serviceById.clear();
        this.serviceByClassField.clear();
        this.fieldTypeMap.clear();
        this.serviceByClass.clear();
        this.updatePolicyByClassField.clear();
        this.updatePolicyByClass.clear();
        this.managedFieldByClass.clear();
        this.managedFieldByClass2.clear();
        this.setterByClass.clear();
        this.dbHookers.clear();
        this.app = null;
    }

    public List<String> managedFields(String className) {
        C.List fields = this.managedFieldByClass.get(className);
        if (null == fields) {
            fields = C.newList();
            Set<String> ss = this.storageFields();
            for (String s : ss) {
                String fn;
                if (!s.startsWith(className + ":") || !S.notEmpty((String)(fn = S.after((String)s, (String)":")))) continue;
                fields.add(fn);
            }
            this.managedFieldByClass.put(className, (List<String>)fields);
        }
        return fields;
    }

    public List<String> managedFields(Class<?> c) {
        String cn = c.getName();
        C.List fields = this.managedFieldByClass2.get(cn);
        if (null == fields) {
            fields = C.newList();
            while (c != Object.class) {
                fields.addAll(this.managedFields(c.getName()));
                c = c.getSuperclass();
            }
            this.managedFieldByClass2.put(cn, (List<String>)fields);
        }
        return fields;
    }

    public void addDbHooker(DbHooker dbHooker) {
        if (!this.dbHookers.contains(dbHooker)) {
            this.dbHookers.add(dbHooker);
            dbHooker.hookLifecycleInterceptors();
            logger.debug("DbHooker[%s] hooked", new Object[]{dbHooker.getClass()});
        }
    }

    public List<DbHooker> dbHookers() {
        return C.list(this.dbHookers);
    }

    public void delete(ISObject sobj) {
        String id = sobj.getAttribute("ss_id");
        IStorageService ss = this.storageService(id);
        String contextPath = sobj.getAttribute("ss_ctx");
        if (S.notBlank((String)contextPath)) {
            ss = ss.subFolder(contextPath);
        }
        ss.remove(sobj.getKey());
    }

    private void initServices(AppConfig config) {
        StoragePluginManager pluginManager = StoragePluginManager.instance();
        if (!pluginManager.hasPlugin()) {
            logger.warn("Storage service not initialized: No storage plugin found");
            return;
        }
        StoragePlugin storagePlugin = pluginManager.theSolePlugin();
        Map storageConfig = config.subSet("ss.");
        if (storageConfig.isEmpty()) {
            if (null == storagePlugin) {
                logger.warn("Storage service not initialized: need to specify default storage service implementation");
                return;
            }
            logger.warn("Storage configuration not found. Will try to init default service with the sole storage plugin: %s", new Object[]{storagePlugin});
            IStorageService svc = storagePlugin.initStorageService(DEFAULT, this.app(), (Map<String, String>)C.newMap((Object[])new Object[0]));
            this.serviceById.put(DEFAULT, svc);
            return;
        }
        String instances = null;
        if (storageConfig.containsKey("ss.instances")) {
            instances = ((String)storageConfig.get("ss.instances")).toString();
            for (String dbId : instances.split("[,;:\\s]+")) {
                this.initService(dbId, storageConfig);
            }
        }
        if (this.serviceById.containsKey(DEFAULT)) {
            return;
        }
        String ssId = null;
        if (storageConfig.containsKey("ss.default.impl")) {
            ssId = DEFAULT;
        } else if (storageConfig.containsKey("ss.impl")) {
            ssId = "";
        }
        if (null != ssId) {
            this.initService(ssId, storageConfig);
        } else if (this.serviceById.size() == 1) {
            IStorageService svc = this.serviceById.values().iterator().next();
            this.serviceById.put(DEFAULT, svc);
            logger.warn("Storage service configuration not found. Use the sole one storage service[%s] as default service", new Object[]{svc.id()});
        } else if (this.serviceById.isEmpty()) {
            if (null == storagePlugin) {
                logger.warn("Storage service not intialized: need to specify default storage service implementation");
            } else {
                logger.warn("Storage configuration not found. Will try to init default service with the sole storage plugin: %s", new Object[]{storagePlugin});
                C.Map svcConf = C.newMap((Object[])new Object[0]);
                String prefix = "ss.";
                for (String key : storageConfig.keySet()) {
                    if (!key.startsWith(prefix)) continue;
                    String o = (String)storageConfig.get(key);
                    svcConf.put(key.substring(prefix.length()), o);
                }
                IStorageService svc = storagePlugin.initStorageService(DEFAULT, this.app(), (Map<String, String>)svcConf);
                this.serviceById.put(DEFAULT, svc);
            }
        } else if (null != instances) {
            IStorageService svc = this.serviceById.get(instances.split("[,;:\\s]+")[0]);
            this.serviceById.put(DEFAULT, (IStorageService)$.notNull((Object)svc));
        } else {
            throw E.invalidConfiguration((String)"Default db service for the application needs to be specified", (Object[])new Object[0]);
        }
    }

    private void initService(String ssId, Map<String, String> conf) {
        String svcId;
        C.Map svcConf = C.newMap((Object[])new Object[0]);
        String prefix = "ss." + (S.empty((String)ssId) ? "" : ssId + ".");
        for (String key : conf.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String o = conf.get(key);
            svcConf.put(key.substring(prefix.length()), o);
        }
        String impl = (String)svcConf.remove("impl");
        String string = svcId = S.empty((String)ssId) ? DEFAULT : ssId;
        if (null == impl) {
            throw new ConfigurationException("Cannot init storage service[%s]: implementation not specified", new Object[]{svcId});
        }
        StoragePlugin plugin = StoragePluginManager.instance().plugin(impl);
        if (null == plugin) {
            throw new ConfigurationException("Cannot init storage service[%s]: implementation not found", new Object[]{svcId});
        }
        svcConf.put("storage.id", "".equals(ssId) ? DEFAULT : ssId);
        IStorageService svc = plugin.initStorageService(ssId, this.app(), (Map<String, String>)svcConf);
        this.serviceById.put(svcId, svc);
        logger.info("storage service[%s] initialized", new Object[]{svcId});
    }

    public static StorageServiceManager instance() {
        return (StorageServiceManager)((Object)App.instance().singleton(StorageServiceManager.class));
    }

    public static String keyCacheField(String fieldName) {
        return S.builder((String)fieldName).append("Key").toString();
    }

    public void copyManagedFields(Object from, Object to) {
        Class<?> cls = from.getClass();
        String className = cls.getName();
        List<String> managedFields = this.managedFields(className);
        if (null == managedFields) {
            return;
        }
        for (String fieldName : managedFields) {
            String keyCacheField = StorageServiceManager.keyCacheField(fieldName);
            $.setProperty((Object)to, (Object)$.getProperty((Object)from, (String)keyCacheField), (String)keyCacheField);
            $.setProperty((Object)to, (Object)$.getProperty((Object)from, (String)fieldName), (String)fieldName);
        }
    }
}

