/*
 * Decompiled with CFR 0.152.
 */
package act.storage.db;

import act.app.App;
import act.app.event.AppEventId;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.plugin.AppServicePlugin;
import act.storage.StorageServiceManager;
import act.storage.StorageServiceManagerInitialized;
import act.storage.db.DbHooker;
import org.osgl.$;

public abstract class DbProbe
extends AppServicePlugin {
    public abstract boolean exists();

    public abstract String dbHookerClass();

    protected void applyTo(final App app) {
        if (this.exists()) {
            app.jobManager().on(AppEventId.CLASS_LOADER_INITIALIZED, new Runnable(){

                @Override
                public void run() {
                    Class hookerClass = $.classForName((String)DbProbe.this.dbHookerClass(), (ClassLoader)app.classLoader());
                    final DbHooker hooker = (DbHooker)app.getInstance(hookerClass);
                    StorageServiceManager ssm = StorageServiceManager.instance();
                    if (null != ssm) {
                        ssm.addDbHooker(hooker);
                    } else {
                        app.eventBus().bind(StorageServiceManagerInitialized.class, (ActEventListener)new ActEventListenerBase<StorageServiceManagerInitialized>((CharSequence)(this.getClass().getName() + ":hook-to-ssm")){

                            public void on(StorageServiceManagerInitialized event) throws Exception {
                                StorageServiceManager ssm = (StorageServiceManager)((Object)event.source());
                                ssm.addDbHooker(hooker);
                            }
                        });
                    }
                }
            });
        }
    }
}

