/*
 * Decompiled with CFR 0.152.
 */
package act.storage.db.impl.ebean;

import act.app.App;
import act.db.ebean.PreEbeanCreation;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.storage.StorageServiceManager;
import act.storage.db.DbHooker;
import act.storage.db.impl.ebean.StorageFieldConverter;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPostLoad;
import javax.persistence.Entity;
import javax.persistence.Transient;

public class EbeanDbHooker
implements DbHooker {
    private StorageServiceManager ssm;

    @Override
    public Class entityAnnotation() {
        return Entity.class;
    }

    @Override
    public Class transientAnnotationType() {
        return Transient.class;
    }

    @Override
    public void hookLifecycleInterceptors() {
        App.instance().eventBus().bind(PreEbeanCreation.class, (ActEventListener)new ActEventListenerBase<PreEbeanCreation>((CharSequence)"storage:hook-ebean-lifecycle-interceptor"){

            public void on(PreEbeanCreation event) throws Exception {
                ServerConfig config = (ServerConfig)event.source();
                StorageFieldConverter postLoad = new StorageFieldConverter(EbeanDbHooker.this.ssm());
                config.add((BeanPostLoad)postLoad);
                BeanPersistController persistController = postLoad;
                config.add(persistController);
            }
        });
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && EbeanDbHooker.class.getName().equals(obj.getClass().getName());
    }

    private synchronized StorageServiceManager ssm() {
        if (null == this.ssm) {
            this.ssm = (StorageServiceManager)((Object)App.instance().singleton(StorageServiceManager.class));
        }
        return this.ssm;
    }
}

