/*
 * Decompiled with CFR 0.152.
 */
package act.storage.db.impl.morphia;

import act.Act;
import act.app.App;
import act.app.DbServiceManager;
import act.db.morphia.MorphiaService;
import act.storage.StorageServiceManager;
import act.storage.db.DbHooker;
import act.storage.db.impl.morphia.StorageFieldConverter;
import java.util.List;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Transient;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;

public class MorphiaDbHooker
implements DbHooker {
    private static Logger logger = LogManager.get(MorphiaDbHooker.class);
    private StorageServiceManager ssm;

    @Override
    public Class entityAnnotation() {
        return Entity.class;
    }

    @Override
    public Class transientAnnotationType() {
        return Transient.class;
    }

    @Override
    public void hookLifecycleInterceptors() {
        DbServiceManager dbServiceManager = Act.app().dbServiceManager();
        List morphiaServices = dbServiceManager.dbServicesByClass(MorphiaService.class);
        StorageFieldConverter storageFieldConverter = new StorageFieldConverter(this.ssm());
        for (MorphiaService morphiaService : morphiaServices) {
            morphiaService.mapper().addInterceptor((EntityInterceptor)storageFieldConverter);
        }
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && MorphiaDbHooker.class.getName().equals(obj.getClass().getName());
    }

    private synchronized StorageServiceManager ssm() {
        if (null == this.ssm) {
            this.ssm = (StorageServiceManager)((Object)App.instance().singleton(StorageServiceManager.class));
        }
        return this.ssm;
    }
}

