/*
 * Decompiled with CFR 0.152.
 */
package act.storage.db.impl.morphia;

import act.Act;
import act.db.DeleteEvent;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.storage.StorageServiceManager;
import act.storage.UpdatePolicy;
import act.storage.db.impl.morphia.MorphiaDbHooker;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mongodb.morphia.AbstractEntityInterceptor;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.mapping.Mapper;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.S;

class StorageFieldConverter
extends AbstractEntityInterceptor
implements EntityInterceptor {
    private static Logger logger = LogManager.get(MorphiaDbHooker.class);
    private StorageServiceManager ssm;
    private CacheService cacheService;
    private Map<Osgl.T2<Class, String>, Class> fieldCache = new HashMap<Osgl.T2<Class, String>, Class>();

    StorageFieldConverter(StorageServiceManager ssm) {
        this.ssm = (StorageServiceManager)((Object)$.notNull((Object)((Object)ssm)));
        this.cacheService = Act.app().cache("storage-morphia");
        Act.app().eventBus().bindAsync(DeleteEvent.class, (ActEventListener)new ActEventListenerBase<DeleteEvent>(){

            public void on(DeleteEvent eventObject) throws Exception {
                StorageFieldConverter.this.onDelete(eventObject.getSource());
            }
        });
    }

    private void onDelete(Object entity) {
        Class<?> c = entity.getClass();
        String cn = c.getName();
        List<String> storageFields = this.ssm.managedFields(c);
        for (String fieldName : storageFields) {
            boolean isCollection = this.ssm.isCollection(cn, fieldName);
            String keyCacheField = StorageServiceManager.keyCacheField(fieldName);
            if (!isCollection) {
                String key = (String)$.getProperty((CacheService)this.cacheService, (Object)entity, (String)keyCacheField);
                if (S.blank((String)key)) continue;
                IStorageService ss = this.ssm.storageService(c, fieldName);
                try {
                    ss.remove(key);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error deleting sobject by key: %s", new Object[]{key});
                }
                continue;
            }
            Collection keys = (Collection)$.getProperty((CacheService)this.cacheService, (Object)entity, (String)keyCacheField);
            if (null == keys) continue;
            for (String key : keys) {
                if (S.blank((String)key)) continue;
                IStorageService ss = this.ssm.storageService(c, fieldName);
                try {
                    ss.remove(key);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error deleting sobject by key: %s", new Object[]{key});
                }
            }
        }
    }

    public void postLoad(Object ent, DBObject dbObj, Mapper mapper) {
        Class<?> c = ent.getClass();
        String cn = c.getName();
        List<String> storageFields = this.ssm.managedFields(c);
        for (String fieldName : storageFields) {
            boolean isCollection = this.ssm.isCollection(cn, fieldName);
            if (!isCollection) {
                String key = ((BasicDBObject)dbObj).getString(fieldName);
                if (S.blank((String)key)) continue;
                IStorageService ss = this.ssm.storageService(c, fieldName);
                try {
                    ISObject sobj = ss.get(key);
                    $.setProperty((Object)ent, (Object)sobj, (String)fieldName);
                    $.setProperty((Object)ent, (Object)key, (String)StorageServiceManager.keyCacheField(fieldName));
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error loading sobject by key: %s", new Object[]{key});
                }
                continue;
            }
            IStorageService ss = this.ssm.storageService(c, fieldName);
            Class<?> fieldType = this.fieldType(c, fieldName);
            Collection sobjs = (Collection)$.cast((Object)Act.app().getInstance(fieldType));
            Collection keys = (Collection)((BasicDBObject)dbObj).get(fieldName);
            if (null == keys) {
                keys = C.list();
            }
            for (String key : keys) {
                try {
                    ISObject sobj = ss.get(key);
                    sobjs.add(sobj);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error loading sobject by key: %s", new Object[]{key});
                }
            }
            $.setProperty((Object)ent, (Object)sobjs, (String)fieldName);
            $.setProperty((Object)ent, (Object)keys, (String)StorageServiceManager.keyCacheField(fieldName));
        }
    }

    public void prePersist(Object ent, DBObject dbObj, Mapper mapper) {
        Class<?> c = ent.getClass();
        String cn = c.getName();
        List<String> storageFields = this.ssm.managedFields(c);
        for (String fieldName : storageFields) {
            UpdatePolicy updatePolicy = this.ssm.updatePolicy(c, fieldName);
            IStorageService ss = this.ssm.storageService(c, fieldName);
            String keyCacheField = StorageServiceManager.keyCacheField(fieldName);
            boolean isCollection = this.ssm.isCollection(cn, fieldName);
            if (!isCollection) {
                ISObject sobj = (ISObject)$.getProperty((CacheService)this.cacheService, (Object)ent, (String)fieldName);
                String newKey = null == sobj ? null : sobj.getKey();
                String prevKey = (String)$.getProperty((CacheService)this.cacheService, (Object)ent, (String)keyCacheField);
                updatePolicy.handleUpdate(prevKey, newKey, ss);
                if (null == sobj) continue;
                if (S.blank((String)newKey) || !ss.isManaged(sobj)) {
                    newKey = ss.getKey();
                }
                if (S.neq((String)newKey, (String)prevKey)) {
                    try {
                        sobj = ss.put(newKey, sobj);
                        $.setProperty((CacheService)this.cacheService, (Object)ent, (Object)newKey, (String)keyCacheField);
                        $.setProperty((CacheService)this.cacheService, (Object)ent, (Object)sobj, (String)fieldName);
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e, "Error persist sobject by key: %s", new Object[]{newKey});
                    }
                }
                dbObj.put(fieldName, (Object)sobj.getKey());
                continue;
            }
            Collection col = (Collection)$.getProperty((CacheService)this.cacheService, (Object)ent, (String)fieldName);
            if (null == col) {
                col = C.newList();
            }
            C.Set newKeys = C.newSet();
            for (ISObject sobj : col) {
                if (null == sobj) continue;
                newKeys.add(sobj.getKey());
            }
            Set oldKeys = (Set)$.getProperty((CacheService)this.cacheService, (Object)ent, (String)keyCacheField);
            if (null == oldKeys) {
                oldKeys = C.newSet();
            }
            C.Set oldKeysCopy = C.newSet((Collection)oldKeys);
            oldKeysCopy.removeAll((Collection<?>)newKeys);
            for (String toBeRemoved : oldKeysCopy) {
                if (S.isBlank((String)toBeRemoved)) continue;
                updatePolicy.handleUpdate(toBeRemoved, null, ss);
            }
            Class<?> fieldType = this.fieldType(c, fieldName);
            Collection updatedCol = (Collection)$.cast((Object)Act.app().getInstance(fieldType));
            newKeys.clear();
            for (ISObject sobj : col) {
                if (null == sobj) continue;
                String newKey = sobj.getKey();
                if (S.blank((String)newKey) || !ss.isManaged(sobj)) {
                    newKey = ss.getKey();
                }
                if (oldKeys.contains(newKey)) continue;
                try {
                    sobj = ss.put(newKey, sobj);
                    updatedCol.add(sobj);
                    newKeys.add(sobj.getKey());
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, "Error persist sobject by key: %s", new Object[]{newKey});
                }
            }
            $.setProperty((CacheService)this.cacheService, (Object)ent, (Object)newKeys, (String)keyCacheField);
            $.setProperty((CacheService)this.cacheService, (Object)ent, (Object)updatedCol, (String)fieldName);
            dbObj.put(fieldName, (Object)newKeys);
        }
    }

    private Class<?> fieldType(Class hostClass, String fieldName) {
        Osgl.T2 fieldCacheKey = $.T2((Object)hostClass, (Object)fieldName);
        Class<?> fieldType = this.fieldCache.get(fieldCacheKey);
        if (null == fieldType) {
            Field field = $.fieldOf((Class)hostClass, (String)fieldName, (boolean)false);
            fieldType = field.getType();
            this.fieldCache.put((Osgl.T2<Class, String>)fieldCacheKey, fieldType);
        }
        return fieldType;
    }
}

