/*
 * Decompiled with CFR 0.152.
 */
package act.storage.db.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class Setter {
    public abstract void set(Object var1, Object var2);

    public static Setter of(Method method) {
        return new MethodSetter(method);
    }

    public static Setter of(Field field) {
        return new FieldSetter(field);
    }

    public static Setter probe(Class c, String fieldName) {
        String mn = S.builder((String)"set").append(S.capFirst((String)fieldName)).toString();
        try {
            Method m = c.getMethod(mn, new Class[0]);
            return Setter.of(m);
        }
        catch (NoSuchMethodException m) {
            try {
                Method m2 = c.getMethod(fieldName, new Class[0]);
                return Setter.of(m2);
            }
            catch (NoSuchMethodException m2) {
                try {
                    return Setter.of(c.getDeclaredField(fieldName));
                }
                catch (NoSuchFieldException e) {
                    throw E.unexpected((Throwable)e);
                }
            }
        }
    }

    private static class FieldSetter
    extends Setter {
        private Field field;

        FieldSetter(Field f) {
            f.setAccessible(true);
            this.field = f;
        }

        @Override
        public void set(Object obj, Object val) {
            try {
                this.field.set(obj, val);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }

    private static class MethodSetter
    extends Setter {
        private Method method;

        MethodSetter(Method m) {
            m.setAccessible(true);
            this.method = m;
        }

        @Override
        public void set(Object obj, Object val) {
            try {
                this.method.invoke(obj, val);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }
}

