/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.BytecodeEnhancerManager;
import act.Destroyable;
import act.Version;
import act.app.App;
import act.app.AppClassLoader;
import act.app.AppManager;
import act.app.AppScanner;
import act.app.DevModeClassLoader;
import act.app.RequestRefreshClassLoader;
import act.app.RequestServerRestart;
import act.app.event.AppEventId;
import act.app.util.AppCrypto;
import act.app.util.NamedPort;
import act.boot.BootstrapClassLoader;
import act.boot.PluginClassProvider;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.boot.app.RunApp;
import act.conf.ActConfLoader;
import act.conf.ActConfig;
import act.conf.AppConfig;
import act.conf.AppConfigKey;
import act.conf.ConfLoader;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.db.DbManager;
import act.event.ActEvent;
import act.event.ActEventListener;
import act.event.EventBus;
import act.handler.RequestHandlerBase;
import act.handler.SimpleRequestHandler;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.inject.DependencyInjector;
import act.job.AppJobManager;
import act.metric.MetricPlugin;
import act.metric.SimpleMetricPlugin;
import act.plugin.AppServicePluginManager;
import act.plugin.GenericPluginManager;
import act.plugin.Plugin;
import act.plugin.PluginScanner;
import act.route.RouteSource;
import act.sys.Env;
import act.util.AppCodeScannerPluginManager;
import act.util.Banner;
import act.util.ClassInfoRepository;
import act.util.SessionManager;
import act.util.SysProps;
import act.view.ViewManager;
import act.xio.Network;
import act.xio.NetworkHandler;
import act.xio.undertow.UndertowNetwork;
import java.io.File;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.OS;
import org.osgl.util.S;

public final class Act {
    public static final String VERSION = Version.fullVersion();
    public static final Logger LOGGER;
    @Deprecated
    public static final Logger logger;
    private static ActConfig conf;
    private static Mode mode;
    private static String nodeGroup;
    private static boolean multiTenant;
    private static AppManager appManager;
    private static ViewManager viewManager;
    private static Network network;
    private static MetricPlugin metricPlugin;
    private static BytecodeEnhancerManager enhancerManager;
    private static SessionManager sessionManager;
    private static AppCodeScannerPluginManager scannerPluginManager;
    private static DbManager dbManager;
    private static GenericPluginManager pluginManager;
    private static AppServicePluginManager appPluginManager;
    private static Map<String, Plugin> genericPluginRegistry;
    private static Map<Class<? extends ActEvent>, List<ActEventListener>> listeners;

    public static List<Class<?>> pluginClasses() {
        ClassLoader cl = Act.class.getClassLoader();
        if (cl instanceof PluginClassProvider) {
            return ((PluginClassProvider)((Object)cl)).pluginClasses();
        }
        LOGGER.warn("Class loader [%s] of Act is not a PluginClassProvider", new Object[]{cl});
        return C.list();
    }

    public static ClassInfoRepository classInfoRepository() {
        ClassLoader cl = Act.class.getClassLoader();
        if (cl instanceof BootstrapClassLoader) {
            return ((BootstrapClassLoader)cl).classInfoRepository();
        }
        LOGGER.warn("Class loader [%s] of Act is not a ActClassLoader", new Object[]{cl});
        return null;
    }

    public static Mode mode() {
        return mode;
    }

    public static boolean isProd() {
        return mode.isProd();
    }

    public static boolean isDev() {
        return mode.isDev();
    }

    public static String profile() {
        return ConfLoader.confSetName();
    }

    public static String nodeGroup() {
        return nodeGroup;
    }

    public static ActConfig conf() {
        return conf;
    }

    public static boolean multiTenant() {
        return multiTenant;
    }

    public static BytecodeEnhancerManager enhancerManager() {
        return enhancerManager;
    }

    public static GenericPluginManager pluginManager() {
        return pluginManager;
    }

    public static DbManager dbManager() {
        return dbManager;
    }

    public static ViewManager viewManager() {
        return viewManager;
    }

    public static SessionManager sessionManager() {
        return sessionManager;
    }

    public static AppCodeScannerPluginManager scannerPluginManager() {
        return scannerPluginManager;
    }

    public static AppServicePluginManager appServicePluginManager() {
        return appPluginManager;
    }

    public static AppManager applicationManager() {
        return appManager;
    }

    public static MetricPlugin metricPlugin() {
        return metricPlugin;
    }

    public static void registerPlugin(Plugin plugin) {
        genericPluginRegistry.put(plugin.getClass().getCanonicalName().intern(), plugin);
    }

    public static <T extends Plugin> T registeredPlugin(Class<T> type) {
        return (T)genericPluginRegistry.get(type.getCanonicalName().intern());
    }

    public static void startServer() {
        Act.start(false, null, null);
    }

    public static void startApp(String appName, String appVersion) {
        String profile;
        String s = System.getProperty("app.mode");
        mode = null != s ? Mode.valueOfIgnoreCase(s) : (S.neq((String)"prod", (String)(profile = SysProps.get(AppConfigKey.PROFILE.key())), (int)4096) ? Mode.DEV : Mode.PROD);
        s = System.getProperty("app.nodeGroup");
        if (null != s) {
            nodeGroup = s;
        }
        Act.start(true, appName, appVersion);
    }

    public static void shutdownApp(App app) {
        if (null == appManager) {
            return;
        }
        if (!appManager.unload(app)) {
            app.destroy();
        }
    }

    private static void start(boolean singleAppServer, String appName, String appVersion) {
        Banner.print(appName, appVersion);
        Act.loadConfig();
        Act.initMetricPlugin();
        Act.initPluginManager();
        Act.initAppServicePluginManager();
        Act.initDbManager();
        Act.initEnhancerManager();
        Act.initViewManager();
        Act.initSessionManager();
        Act.initAppCodeScannerPluginManager();
        Act.loadPlugins();
        Act.initNetworkLayer();
        Act.initApplicationManager();
        LOGGER.info("loading application(s) ...");
        if (singleAppServer) {
            appManager.loadSingleApp(appName);
        } else {
            appManager.scan();
        }
        Act.startNetworkLayer();
        Thread.currentThread().setContextClassLoader(Act.class.getClassLoader());
        App app = Act.app();
        if (null == app) {
            Act.shutdownNetworkLayer();
            throw new UnexpectedException("App not found. Please make sure your app start directory is correct");
        }
        Act.emit(AppEventId.ACT_START);
        Act.writePidFile();
    }

    public static void shutdown() {
        Act.clearPidFile();
        Act.shutdownNetworkLayer();
        Act.destroyApplicationManager();
        Act.unloadPlugins();
        Act.destroyAppCodeScannerPluginManager();
        Act.destroySessionManager();
        Act.destroyViewManager();
        Act.destroyEnhancerManager();
        Act.destroyDbManager();
        Act.destroyAppServicePluginManager();
        Act.destroyPluginManager();
        Act.destroyMetricPlugin();
        Act.unloadConfig();
        Act.destroyNetworkLayer();
    }

    public static RequestServerRestart requestRestart() {
        E.illegalStateIf((!Act.isDev() ? 1 : 0) != 0);
        throw new RequestServerRestart();
    }

    public static RequestRefreshClassLoader requestRefreshClassLoader() {
        E.illegalStateIf((!Act.isDev() ? 1 : 0) != 0);
        throw RequestRefreshClassLoader.INSTANCE;
    }

    public static void hook(App app) {
        int port = app.config().httpPort();
        network.register(port, new NetworkHandler(app));
        List<NamedPort> portList = app.config().namedPorts();
        for (NamedPort np : portList) {
            network.register(np.port(), new NetworkHandler(app, np));
        }
    }

    public static synchronized void trigger(ActEvent<?> event) {
        List<ActEventListener> list = listeners.get(event.getClass());
        if (null != list) {
            for (ActEventListener l : list) {
                try {
                    l.on(event);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e, "error calling act event listener %s on event %s", new Object[]{l.id(), event});
                }
            }
        }
    }

    public static synchronized <T extends ActEvent> void registerEventListener(Class<T> eventClass, ActEventListener<T> listener) {
        C.List list = listeners.get(eventClass);
        if (null == list) {
            list = C.newList();
            listeners.put(eventClass, (List<ActEventListener>)list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public static String cuid() {
        return App.instance().cuid();
    }

    public static AppCrypto crypto() {
        return Act.app().crypto();
    }

    public static App app() {
        return App.instance();
    }

    public static AppConfig appConfig() {
        return App.instance().config();
    }

    public static <T> T singleton(Class<T> singletonClass) {
        return App.instance().singleton(singletonClass);
    }

    public static CacheService cache() {
        return App.instance().cache();
    }

    public static void emit(AppEventId appEvent) {
        App.instance().emit(appEvent);
    }

    public static void trigger(AppEventId appEventId) {
        Act.emit(appEventId);
    }

    public static EventBus eventBus() {
        return App.instance().eventBus();
    }

    public static AppJobManager jobManager() {
        return App.instance().jobManager();
    }

    public static <DI extends DependencyInjector> DI injector() {
        return App.instance().injector();
    }

    @Deprecated
    public static <T> T newInstance(String className) {
        return App.instance().getInstance(className);
    }

    public static <T> T getInstance(String className) {
        return Act.app().getInstance(className);
    }

    @Deprecated
    public static <T> T newInstance(Class<T> clz) {
        return App.instance().getInstance(clz);
    }

    public static <T> T getInstance(Class<? extends T> clz) {
        return Act.app().getInstance(clz);
    }

    public static int classCacheSize() {
        return ((FullStackAppBootstrapClassLoader)Act.class.getClassLoader()).libBCSize();
    }

    public static void get(String url, SimpleRequestHandler handler) {
        Act.get(url, RequestHandlerBase.wrap(handler));
    }

    public static void getNonblock(String url, SimpleRequestHandler handler) {
        Act.get(url, RequestHandlerBase.wrap(handler).setExpress());
    }

    public static void post(String url, SimpleRequestHandler handler) {
        Act.post(url, RequestHandlerBase.wrap(handler));
    }

    public static void put(String url, SimpleRequestHandler handler) {
        Act.put(url, RequestHandlerBase.wrap(handler));
    }

    public static void delete(String url, SimpleRequestHandler handler) {
        Act.delete(url, RequestHandlerBase.wrap(handler));
    }

    public static void get(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.GET, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void post(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.POST, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void put(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.PUT, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void delete(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.DELETE, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void start() throws Exception {
        StackTraceElement[] sa = new RuntimeException().getStackTrace();
        E.unexpectedIf((sa.length < 2 ? 1 : 0) != 0, (String)"Whoops!", (Object[])new Object[0]);
        StackTraceElement ste = sa[1];
        String className = ste.getClassName();
        E.unexpectedIf((!className.contains(".") ? 1 : 0) != 0, (String)"The main class must have package name to use Act", (Object[])new Object[0]);
        RunApp.start(S.beforeLast((String)className, (String)"."));
    }

    private static boolean isItPackageName(String s) {
        if (s.length() < 4) {
            return false;
        }
        if (s.contains(" ") || s.contains("\t") || !s.contains(".")) {
            return false;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return false;
        }
        return Act.isFullyQualifiedClassname(s);
    }

    private static boolean isFullyQualifiedClassname(String s) {
        if (s == null) {
            return false;
        }
        String[] parts = s.split("[\\.]");
        if (parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            StringCharacterIterator iter = new StringCharacterIterator(part);
            char c = iter.first();
            if (c == '\uffff') {
                return false;
            }
            if (!Character.isJavaIdentifierStart(c) && !Character.isIdentifierIgnorable(c)) {
                return false;
            }
            c = iter.next();
            while (c != '\uffff') {
                if (!Character.isJavaIdentifierPart(c) && !Character.isIdentifierIgnorable(c)) {
                    return false;
                }
                c = iter.next();
            }
        }
        return true;
    }

    public static void start(String appNameOrScanPackage) throws Exception {
        if (Act.isItPackageName(appNameOrScanPackage)) {
            RunApp.start(appNameOrScanPackage);
        } else {
            StackTraceElement[] sa = new RuntimeException().getStackTrace();
            E.unexpectedIf((sa.length < 2 ? 1 : 0) != 0, (String)"Whoops!", (Object[])new Object[0]);
            StackTraceElement ste = sa[1];
            String className = ste.getClassName();
            E.unexpectedIf((!className.contains(".") ? 1 : 0) != 0, (String)"The main class must have package name to use Act", (Object[])new Object[0]);
            RunApp.start(appNameOrScanPackage, Version.appVersion(), S.beforeLast((String)className, (String)"."));
        }
    }

    public static void start(String appName, String scanPackage) throws Exception {
        RunApp.start(appName, Version.appVersion(), scanPackage);
    }

    public static void start(String appName, Class<?> anyAppClass) throws Exception {
        RunApp.start(appName, Version.appVersion(), anyAppClass);
    }

    public static void start(Class<?> anyController) throws Exception {
        RunApp.start(anyController);
    }

    public static void start(String appName, String appVersion, Class<?> anyController) throws Exception {
        RunApp.start(appName, appVersion, anyController);
    }

    public static void start(String appName, String appVersion, String packageName) throws Exception {
        RunApp.start(appName, appVersion, packageName);
    }

    private static void loadConfig() {
        LOGGER.debug("loading configuration ...");
        String s = SysProps.get("act.mode");
        if (null != s) {
            mode = Mode.valueOfIgnoreCase(s);
        }
        LOGGER.debug("Act starts in %s mode", new Object[]{mode});
        conf = (ActConfig)new ActConfLoader().load(null);
    }

    private static void unloadConfig() {
        conf = null;
    }

    private static void loadPlugins() {
        LOGGER.debug("scanning plugins ...");
        long ts = $.ms();
        new PluginScanner().scan();
        LOGGER.debug("plugin scanning finished in %sms", new Object[]{$.ms() - ts});
    }

    private static void unloadPlugins() {
        new PluginScanner().unload();
    }

    private static void initViewManager() {
        LOGGER.debug("initializing view manager ...");
        viewManager = new ViewManager();
    }

    private static void destroyViewManager() {
        if (null != viewManager) {
            viewManager.destroy();
            viewManager = null;
        }
    }

    private static void initMetricPlugin() {
        LOGGER.debug("initializing metric plugin ...");
        metricPlugin = new SimpleMetricPlugin();
    }

    private static void destroyMetricPlugin() {
        if (null != metricPlugin) {
            Destroyable.Util.tryDestroy(metricPlugin);
            metricPlugin = null;
        }
    }

    private static void initPluginManager() {
        LOGGER.debug("initializing generic plugin manager ...");
        pluginManager = new GenericPluginManager();
    }

    private static void destroyPluginManager() {
        if (null != pluginManager) {
            pluginManager.destroy();
            pluginManager = null;
        }
    }

    private static void initAppServicePluginManager() {
        LOGGER.debug("initializing app service plugin manager ...");
        appPluginManager = new AppServicePluginManager();
    }

    private static void destroyAppServicePluginManager() {
        if (null != appPluginManager) {
            appPluginManager.destroy();
            appPluginManager = null;
        }
    }

    private static void initSessionManager() {
        LOGGER.debug("initializing session manager ...");
        sessionManager = new SessionManager();
    }

    private static void destroySessionManager() {
        if (null != sessionManager) {
            sessionManager.destroy();
            sessionManager = null;
        }
    }

    private static void initDbManager() {
        LOGGER.debug("initializing db manager ...");
        dbManager = new DbManager();
    }

    private static void destroyDbManager() {
        if (null != dbManager) {
            dbManager.destroy();
            dbManager = null;
        }
    }

    private static void initAppCodeScannerPluginManager() {
        LOGGER.debug("initializing app code scanner plugin manager ...");
        scannerPluginManager = new AppCodeScannerPluginManager();
    }

    private static void destroyAppCodeScannerPluginManager() {
        if (null != scannerPluginManager) {
            scannerPluginManager.destroy();
            scannerPluginManager = null;
        }
    }

    static void initEnhancerManager() {
        LOGGER.debug("initializing byte code enhancer manager ...");
        enhancerManager = new BytecodeEnhancerManager();
    }

    private static void destroyEnhancerManager() {
        if (null != enhancerManager) {
            enhancerManager.destroy();
            enhancerManager = null;
        }
    }

    private static void initNetworkLayer() {
        LOGGER.debug("initializing network layer ...");
        network = new UndertowNetwork();
    }

    private static void destroyNetworkLayer() {
        if (null != network) {
            network.destroy();
            network = null;
        }
    }

    private static void startNetworkLayer() {
        if (network.isDestroyed()) {
            return;
        }
        LOGGER.debug("starting network layer ...");
        network.start();
    }

    private static void shutdownNetworkLayer() {
        LOGGER.debug("shutting down network layer ...");
        network.shutdown();
    }

    protected static void initApplicationManager() {
        LOGGER.debug("initializing application manager ...");
        appManager = AppManager.create();
    }

    private static void destroyApplicationManager() {
        if (null != appManager) {
            appManager.destroy();
            appManager = null;
        }
    }

    private static void writePidFile() {
        String pidFile = System.getProperty("pidfile");
        if (S.blank((String)pidFile)) {
            return;
        }
        OS os = OS.get();
        if (os.isLinux()) {
            try {
                String pid = Env.PID.get();
                IO.writeContent((CharSequence)pid, (File)new File(pidFile));
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e, "Error writing pid file: %s", new Object[]{e.getMessage()});
            }
        } else {
            LOGGER.warn("Write pid file not supported on non-linux system");
        }
    }

    private static void clearPidFile() {
        String pidFile = System.getProperty("pidfile");
        if (S.blank((String)pidFile)) {
            return;
        }
        try {
            File file = new File(pidFile);
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e, "Error delete pid file: %s", new Object[]{pidFile});
        }
    }

    static {
        logger = LOGGER = L.get(Act.class);
        mode = Mode.PROD;
        nodeGroup = "";
        multiTenant = false;
        genericPluginRegistry = C.newMap((Object[])new Object[0]);
        listeners = C.newMap((Object[])new Object[0]);
    }

    public static enum F {

        public static final Osgl.F0<Mode> MODE_ACCESSOR = new Osgl.F0<Mode>(){

            public Mode apply() throws NotAppliedException, Osgl.Break {
                return mode;
            }
        };
    }

    public static enum Mode {
        PROD,
        DEV{

            @Override
            public AppScanner appScanner() {
                return AppScanner.SINGLE_APP_SCANNER;
            }

            @Override
            public AppClassLoader classLoader(App app) {
                return new DevModeClassLoader(app);
            }
        };

        private final String confPrefix = "%" + this.name().toLowerCase() + ".";

        public boolean isDev() {
            return DEV == this;
        }

        public boolean isProd() {
            return PROD == this;
        }

        public String configKey(String key) {
            return this.confPrefix + key;
        }

        public AppScanner appScanner() {
            return AppScanner.DEF_SCANNER;
        }

        public AppClassLoader classLoader(App app) {
            return new AppClassLoader(app);
        }

        public ControllerAction createRequestHandler(ActionMethodMetaInfo action, App app) {
            return ReflectedHandlerInvoker.createControllerAction(action, app);
        }

        public BeforeInterceptor createBeforeInterceptor(InterceptorMethodMetaInfo before, App app) {
            return ReflectedHandlerInvoker.createBeforeInterceptor(before, app);
        }

        public AfterInterceptor createAfterInterceptor(InterceptorMethodMetaInfo after, App app) {
            return ReflectedHandlerInvoker.createAfterInterceptor(after, app);
        }

        public ExceptionInterceptor createExceptionInterceptor(CatchMethodMetaInfo ex, App app) {
            return ReflectedHandlerInvoker.createExceptionInterceptor(ex, app);
        }

        public FinallyInterceptor createFinallyInterceptor(InterceptorMethodMetaInfo fin, App app) {
            return ReflectedHandlerInvoker.createFinannyInterceptor(fin, app);
        }

        public static Mode valueOfIgnoreCase(String mode) {
            return Mode.valueOf(mode.trim().toUpperCase());
        }
    }
}

