/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.Destroyable;
import act.app.App;
import act.asm.ClassWriter;
import act.util.AppByteCodeEnhancer;
import act.util.AsmByteCodeEnhancer;
import act.util.ByteCodeVisitor;
import act.util.DestroyableBase;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Osgl;
import org.osgl.util.C;

public class BytecodeEnhancerManager
extends DestroyableBase {
    private List<AppByteCodeEnhancer> appEnhancers = C.newList();
    private List<AsmByteCodeEnhancer> generalEnhancers = C.newList();

    public void register(AsmByteCodeEnhancer enhancer) {
        if (enhancer instanceof AppByteCodeEnhancer) {
            this.appEnhancers.add((AppByteCodeEnhancer)enhancer);
        } else {
            this.generalEnhancers.add(enhancer);
        }
    }

    public void register(AppByteCodeEnhancer enhancer) {
        this.appEnhancers.add(enhancer);
    }

    public ByteCodeVisitor appEnhancer(App app, String className, Osgl.Var<ClassWriter> cw) {
        List<AppByteCodeEnhancer> l = this.appFilter(app, className);
        return l.isEmpty() ? null : ByteCodeVisitor.chain(cw, l);
    }

    public ByteCodeVisitor generalEnhancer(String className, Osgl.Var<ClassWriter> cw) {
        List<AsmByteCodeEnhancer> l = this.generalFilter(className);
        return l.isEmpty() ? null : ByteCodeVisitor.chain(cw, l);
    }

    private List<AppByteCodeEnhancer> appFilter(App app, String className) {
        C.List l = C.newList();
        for (AppByteCodeEnhancer e : this.appEnhancers) {
            AppByteCodeEnhancer e0 = (AppByteCodeEnhancer)e.clone();
            e0.app(app);
            if (!e0.isTargetClass(className)) continue;
            l.add(e0);
        }
        return l;
    }

    private List<AsmByteCodeEnhancer> generalFilter(String className) {
        C.List l = C.newList();
        for (AsmByteCodeEnhancer e : this.generalEnhancers) {
            Object e0 = e.clone();
            if (!((AsmByteCodeEnhancer)e0).isTargetClass(className)) continue;
            l.add(((AsmByteCodeEnhancer)e0).clone());
        }
        return l;
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.appEnhancers, ApplicationScoped.class);
        this.appEnhancers.clear();
        Destroyable.Util.tryDestroyAll(this.generalEnhancers, ApplicationScoped.class);
        this.generalEnhancers.clear();
    }
}

