/*
 * Decompiled with CFR 0.152.
 */
package act;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import org.osgl.util.IO;

public interface Destroyable {
    public void destroy();

    public boolean isDestroyed();

    public Class<? extends Annotation> scope();

    public static enum Util {


        public static void destroyAll(Collection<? extends Destroyable> col) {
            Util.destroyAll(col, null);
        }

        public static void destroyAll(Collection<? extends Destroyable> col, Class<? extends Annotation> scope) {
            for (Destroyable destroyable : col) {
                if (!Util.inScope(destroyable, scope)) continue;
                destroyable.destroy();
                if (!(destroyable instanceof Closeable)) continue;
                IO.close((Closeable)((Closeable)((Object)destroyable)));
            }
        }

        @Deprecated
        public static void tryDestroyAll(Collection<?> col) {
            Util.tryDestroyAll(col, null);
        }

        public static void tryDestroyAll(Collection<?> col, Class<? extends Annotation> scope) {
            if (null == col) {
                return;
            }
            for (Object o : col) {
                if (!Util.inScope(o, scope)) continue;
                if (o instanceof Destroyable) {
                    ((Destroyable)o).destroy();
                }
                if (!(o instanceof Closeable)) continue;
                IO.close((Closeable)((Closeable)o));
            }
            col.clear();
        }

        public static void tryDestroy(Object o) {
            Util.tryDestroy(o, null);
        }

        public static void tryDestroy(Object o, Class<? extends Annotation> scope) {
            if (null == o) {
                return;
            }
            if (!Util.inScope(o, scope)) {
                return;
            }
            if (o instanceof Destroyable) {
                ((Destroyable)o).destroy();
            }
            if (o instanceof Closeable) {
                IO.close((Closeable)((Closeable)o));
            }
        }

        private static boolean inScope(Object o, Class<? extends Annotation> scope) {
            if (null == o) {
                return false;
            }
            if (null == scope || scope == ApplicationScoped.class) {
                return true;
            }
            Class<?> c = o.getClass();
            if (c.isAnnotationPresent(scope)) {
                return true;
            }
            if (scope == SessionScoped.class) {
                return c.isAnnotationPresent(RequestScoped.class);
            }
            return false;
        }
    }
}

