/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.Act;
import act.Version;
import act.Zen;
import act.cli.CliContext;
import act.cli.Command;
import act.cli.Optional;
import act.cli.Required;
import act.sys.Env;
import act.util.PropertySpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Min;
import org.joda.time.LocalDateTime;
import org.osgl.$;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class SysUtilAdmin {
    private CliContext context = CliContext.current();

    @Command(name="act.pid", help="Print current process ID")
    public String pid() {
        return Env.PID.get();
    }

    @Command(name="act.meminfo, act.mi", help="Print memory info")
    public void memInfo(@Optional(value="monitor memory usage") boolean monitor, @Optional(value="human readable") boolean human, CliContext context) {
        block6: {
            int factor = human ? 0x100000 : 1;
            Runtime runtime = Runtime.getRuntime();
            if (monitor) {
                context.session().dameon(true);
                long ts0 = $.ms();
                long lastUsed = 0L;
                context.println();
                context.println("                      ====== MEMORY INFO ======", new Object[0]);
                context.println();
                context.flush();
                int count = 0;
                while (true) {
                    long ts = ($.ms() - ts0) / 1000L;
                    if (count % 6 == 0) {
                        context.println("", new Object[0]);
                        context.println("%7s%15s%12s%12s%12s%12s", "time(s)", "cached(cls#)", "total", "free", "used", "delta");
                    }
                    long total = runtime.totalMemory() / (long)factor;
                    long free = runtime.freeMemory() / (long)factor;
                    long used = total - free;
                    long delta = 0 == count++ ? 0L : used - lastUsed;
                    lastUsed = used;
                    int cached = Act.classCacheSize();
                    context.println("%7d%15d%12d%12d%12d%12d", ts, cached, total, free, used, delta);
                    context.flush();
                    if (context.disconnected()) {
                        context.session().dameon(false);
                        break block6;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        break block6;
                    }
                }
            }
            long total = runtime.totalMemory() / (long)factor;
            long free = runtime.freeMemory() / (long)factor;
            int cached = Act.classCacheSize();
            context.println("====== MEMORY INFO ======", new Object[0]);
            context.println("%12s: %11d", "total", total);
            context.println("%12s: %11d", "free", free);
            context.println("%12s: %11d", "used", total - free);
            context.println("%12s: %11d", "cached(cls#)", cached);
            context.flush();
        }
    }

    @Command(name="act.gc", help="Run GC")
    public void gc(CliContext context) {
        System.gc();
        context.println("GC executed", new Object[0]);
        this.memInfo(false, false, context);
    }

    @Command(name="act.version, act.ver", help="Print actframework version")
    public String version() {
        return Version.fullVersion().replace("-S-", "-SNAPSHOT-");
    }

    @Command(name="act.pwd", help="Print name of the current working directory")
    public String pwd() {
        return SysUtilAdmin.pwd(this.context).getAbsolutePath();
    }

    @Command(name="act.ls, act.dir, act.ll", help="List files in the current working directory")
    @PropertySpec(value={"path as name,size,timestamp"})
    public List<FileInfo> ls(@Optional(value="specify the path to be listed") String path, @Optional(lead={"-a"}, help="display hidden files") boolean showHidden, String path2, CliContext ctx) {
        if (S.blank((String)path) && S.notBlank((String)path2)) {
            path = path2;
        }
        if (S.blank((String)path)) {
            ctx.println(this.pwd(), new Object[0]);
            return SysUtilAdmin.dir(this.curDir(), showHidden, this.context);
        }
        ctx.println(path, new Object[0]);
        File file = this.getFile(path);
        if (!file.exists()) {
            ctx.println("%s is not a file or directory", path);
            return null;
        }
        if (file.isDirectory()) {
            return SysUtilAdmin.dir(file, showHidden, this.context);
        }
        return C.list((Object)new FileInfo(file.getParentFile(), file));
    }

    @Command(name="act.cd", help="Change working directory")
    public void cd(@Required(value="specify the path to which the working directory to be changed") String path) {
        if (S.blank((String)path)) {
            this.context.println(this.pwd(), new Object[0]);
            return;
        }
        File file = this.getFile(path);
        if (path.contains("..")) {
            try {
                file = new File(file.getCanonicalPath());
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
        if (!file.isDirectory()) {
            this.context.println("path is not a directory", new Object[0]);
            return;
        }
        this.context.chDir(file);
        this.context.println("current working directory changed to %s", file.getAbsolutePath());
    }

    @Command(name="act.cat", help="print file content")
    public void cat(@Required(lead={"-f --url"}, help="specify the file/resource URL to be printed out", errorTemplate="error accessing file/resource at %s") SObject sobj, @Optional(help="specify the maximum lines to be printed out") int limit, @Optional(help="specify the begin line to be printed out", defVal="0") @Min(value=0L) int begin, @Optional(help="specify the end line to be printed out") int end, @Optional(help="specify begin end as range, e.g. 5-8") String range, @Optional(lead={"-n,--line-number"}, help="print line number") boolean printLineNumber, @Optional(lead={"-q,--grep"}, help="specify search criteria") String q, CliContext context) {
        if (S.notBlank((String)range)) {
            range = range.trim();
            String[] sa = range.split("[\\s,\\-:]+");
            try {
                begin = Integer.parseInt(sa[0]);
                end = Integer.parseInt(sa[1]);
            }
            catch (Exception e) {
                context.println("Invalid range: %s. Try something like '3-6'", range);
                return;
            }
        } else {
            int defLimit;
            int n = defLimit = S.blank((String)q) ? 20 : Integer.MAX_VALUE;
            if (begin <= 0) {
                begin = 1;
            }
            if (end <= 0) {
                end = begin + (limit <= 0 ? defLimit : limit) - 1;
            }
        }
        List lines = IO.readLines((InputStream)sobj.asInputStream(), (int)end);
        int len = lines.size();
        context.println("", new Object[0]);
        for (int i = begin - 1; i < len; ++i) {
            String line = (String)lines.get(i);
            if (S.notBlank((String)q) && !line.contains(q)) continue;
            if (printLineNumber) {
                context.print("%5s | ", i + 1);
            }
            context.println(line, new Object[0]);
        }
        context.println("", new Object[0]);
    }

    private File getFile(String path) {
        return this.context.getFile(path);
    }

    private File curDir() {
        return SysUtilAdmin.pwd(this.context);
    }

    private static File pwd(CliContext context) {
        return context.curDir();
    }

    private static List<FileInfo> dir(File file, boolean showHidden, CliContext context) {
        C.List list = C.newList();
        File[] files = file.listFiles();
        if (null == files) {
            context.println("Invalid dir: %s", file.getAbsolutePath());
            return C.list();
        }
        File parent = file.getAbsoluteFile();
        for (File f0 : files) {
            if (!showHidden && f0.isHidden()) continue;
            list.add((Object)new FileInfo(parent, f0));
        }
        list = list.sorted();
        return list;
    }

    private static boolean isBinary(InputStream in) {
        try {
            int size = in.available();
            if (size > 1024) {
                size = 1024;
            }
            byte[] data = new byte[size];
            in.read(data);
            in.close();
            int ascii = 0;
            int other = 0;
            for (int i = 0; i < data.length; ++i) {
                byte b = data[i];
                if (b < 9) {
                    return true;
                }
                if (b == 9 || b == 10 || b == 12 || b == 13) {
                    ++ascii;
                    continue;
                }
                if (b >= 32 && b <= 126) {
                    ++ascii;
                    continue;
                }
                ++other;
            }
            return other != 0 && 100 * other / (ascii + other) > 95;
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Command(value="act.zen", help="give me the zen words")
    public static String zen() {
        return Zen.wordsOfTheDay();
    }

    public static class FileInfo
    implements Comparable<FileInfo> {
        String context;
        String path;
        String size;
        boolean hidden;
        LocalDateTime timestamp;
        boolean isDir;

        private FileInfo(File parent, File file) {
            this.isDir = file.isDirectory();
            this.context = null == parent ? "/" : parent.getAbsolutePath();
            this.path = this.printPath(file);
            this.size = this.printSize(file);
            this.timestamp = LocalDateTime.fromDateFields((Date)new Date(file.lastModified()));
            this.hidden = file.isHidden();
        }

        public String getContext() {
            return this.context;
        }

        public String getPath() {
            return this.path;
        }

        public String getSize() {
            return this.size;
        }

        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public int compareTo(FileInfo that) {
            if (this.isDir) {
                return that.isDir ? this.path.compareTo(that.path) : -1;
            }
            return that.isDir ? 1 : this.path.compareTo(that.path);
        }

        private String printPath(File file) {
            if (this.isDir) {
                return S.newBuffer((String)"[").append(file.getName()).append("]").toString();
            }
            return file.getName();
        }

        private String printSize(File file) {
            String unit;
            long len = file.length();
            if (len < 1024L) {
                unit = "B";
            } else if ((len /= 1024L) < 1024L) {
                unit = "KB";
            } else if ((len /= 1024L) < 1024L) {
                unit = "MB";
            } else if ((len /= 1024L) < 1024L) {
                unit = "GB";
            } else {
                len /= 1024L;
                unit = "TB";
            }
            return S.newBuffer((long)len).append(unit).toString();
        }
    }
}

