/*
 * Decompiled with CFR 0.152.
 */
package act;

import java.io.IOException;
import java.util.Properties;
import org.osgl.util.E;
import org.osgl.util.S;

public class Version {
    private static boolean snapshot;
    private static String version;
    private static String buildNumber;
    private static String appVersion;

    public static boolean snapshot() {
        return snapshot;
    }

    public static String version() {
        return version;
    }

    public static String buildNumber() {
        return buildNumber;
    }

    public static String fullVersion() {
        return S.fmt((String)"%s-%s", (Object[])new Object[]{version, buildNumber});
    }

    public static synchronized String appVersion() {
        if (null == appVersion) {
            Properties p = new Properties();
            try {
                p.load(Version.class.getResourceAsStream("/app.version"));
                appVersion = p.getProperty("app.version");
            }
            catch (Exception e) {
                appVersion = "0.0.1";
            }
        }
        return appVersion;
    }

    static {
        Properties p = new Properties();
        try {
            p.load(Version.class.getResourceAsStream("/act.version"));
            version = p.getProperty("version");
            if (version.endsWith("SNAPSHOT")) {
                version = "v" + version.replace("-SNAPSHOT", "");
                snapshot = true;
            } else {
                version = "R" + version;
            }
            buildNumber = p.getProperty("build");
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }
}

