/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.controller.Controller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.mvc.annotation.GetAction;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.rythmengine.utils.S;

public final class Zen {
    private static final List<String> WORDS = Zen.loadWords();

    private Zen() {
    }

    public static String wordsOfTheDay() {
        return (String)$.random(WORDS);
    }

    @GetAction(value={"zen"})
    public static Result zen() {
        return Controller.Util.text(S.join((String)"\n\n", WORDS), new Object[0]);
    }

    private static List<String> loadWords() {
        URL url = Zen.class.getResource("/zen.txt");
        C.List words = C.newList(Zen.defaultWords());
        if (null != url) {
            try {
                words.addAll(IO.readLines((InputStream)url.openStream()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<String> retVal = new ArrayList<String>(words.size());
        for (String s : words) {
            if (s.contains("\n")) {
                s = s.replaceAll("\n", "\n          ");
            } else if (s.contains("\\n")) {
                s = s.replaceAll("\\\\n", "\n          ");
            }
            retVal.add(s);
        }
        return retVal;
    }

    private static List<String> defaultWords() {
        return C.listOf((Object[])new String[]{"Beautiful is better than ugly.", "Explicit is better than implicit.", "Simple is better than complex.", "Complex is better than complicated.", "Flat is better than nested.", "Sparse is better than dense.", "Readability counts.", "Special cases aren't special enough to break the rules. \nAlthough practicality beats purity.", "Errors should never pass silently \nUnless explicitly silenced.", "In the face of ambiguity, refuse the temptation to guess.", "There should be one-- and preferably only one --obvious way to do it.\nAlthough that way may not be obvious at first unless you're Dutch.", "Now is better than never. \nAlthough never is often better than *right* now.", "If the implementation is hard to explain, it's a bad idea.", "If the implementation is easy to explain, it may be a good idea.", "Namespaces are one honking great idea -- let's do more of those!", "Simple things should be simple, complex things should be possible."});
    }
}

