/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.conf.AppConfig;
import act.controller.Controller;
import act.data.MapUtil;
import act.data.RequestBodyParser;
import act.event.ActEvent;
import act.event.EventBus;
import act.event.SystemEvent;
import act.handler.RequestHandler;
import act.i18n.LocaleResolver;
import act.route.Router;
import act.security.CORS;
import act.util.ActContext;
import act.util.PropertySpec;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.osgl.$;
import org.osgl.concurrent.ContextLocal;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.storage.ISObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.web.util.UserAgent;

@RequestScoped
public class ActionContext
extends ActContext.Base<ActionContext>
implements Destroyable {
    public static final String ATTR_CSRF_TOKEN = "__csrf__";
    public static final String ATTR_CSR_TOKEN_PREFETCH = "__csrf_prefetch__";
    public static final String ATTR_WAS_UNAUTHENTICATED = "__was_unauthenticated__";
    public static final String ATTR_HANDLER = "__act_handler__";
    public static final String ATTR_PATH_VARS = "__path_vars__";
    public static final String ATTR_RESULT = "__result__";
    public static final String ATTR_EXCEPTION = "__exception__";
    public static final String ATTR_CURRENT_FILE_INDEX = "__file_id__";
    public static final String REQ_BODY = "_body";
    private H.Request request;
    private H.Response response;
    private H.Session session;
    private H.Flash flash;
    private Set<Map.Entry<String, String[]>> requestParamCache;
    private Map<String, String> extraParams;
    private volatile Map<String, String[]> bodyParams;
    private Map<String, String[]> allParams;
    private String actionPath;
    private State state;
    private Map<String, Object> controllerInstances;
    private Map<String, ISObject[]> uploads;
    private Router router;
    private RequestHandler handler;
    private UserAgent ua;
    private String sessionKeyUsername;
    private LocaleResolver localeResolver;
    private boolean disableCors;
    private boolean disableCsrf;
    private Boolean hasTemplate;
    private H.Status forceResponseStatus;
    private static ContextLocal<ActionContext> _local = $.contextLocal();
    public static final String METHOD_GET_CURRENT = "current";

    @Inject
    private ActionContext(App app, H.Request request, H.Response response) {
        super(app);
        E.NPE((Object)app, (Object)request, (Object)response);
        request.context((Object)this);
        response.context((Object)this);
        this.request = request;
        this.response = response;
        this._init();
        this.state = State.CREATED;
        AppConfig<?> config = app.config();
        this.disableCors = !config.corsEnabled();
        this.disableCsrf = this.req().method().safe();
        this.sessionKeyUsername = config.sessionKeyUsername();
        this.localeResolver = new LocaleResolver(this);
    }

    public State state() {
        return this.state;
    }

    public boolean isSessionDissolved() {
        return this.state == State.SESSION_DISSOLVED;
    }

    public boolean isSessionResolved() {
        return this.state == State.SESSION_RESOLVED;
    }

    public H.Request req() {
        return this.request;
    }

    public H.Response resp() {
        return this.response;
    }

    public H.Cookie cookie(String name) {
        return this.req().cookie(name);
    }

    public H.Session session() {
        return this.session;
    }

    public String session(String key) {
        return this.session.get(key);
    }

    public H.Session session(String key, String value) {
        return (H.Session)this.session.put(key, value);
    }

    public H.Flash flash() {
        return this.flash;
    }

    public String flash(String key) {
        return this.flash.get(key);
    }

    public H.Flash flash(String key, String value) {
        return this.flash.put(key, value);
    }

    public Router router() {
        return this.router;
    }

    public ActionContext router(Router router) {
        this.router = (Router)$.notNull((Object)router);
        return this;
    }

    @Override
    public <T> T renderArg(String name) {
        return super.renderArg(name);
    }

    @Override
    public ActionContext renderArg(String name, Object val) {
        return (ActionContext)super.renderArg(name, val);
    }

    @Override
    public Map<String, Object> renderArgs() {
        return super.renderArgs();
    }

    @Override
    public ActionContext templatePath(String templatePath) {
        return (ActionContext)super.templatePath(templatePath);
    }

    public RequestHandler handler() {
        return this.handler;
    }

    public ActionContext handler(RequestHandler handler) {
        E.NPE((Object)handler);
        this.handler = handler;
        return this;
    }

    @Override
    public H.Format accept() {
        return this.req().accept();
    }

    @Override
    public ActionContext accept(H.Format fmt) {
        this.req().accept(fmt);
        return this;
    }

    public Boolean hasTemplate() {
        return this.hasTemplate;
    }

    public ActionContext hasTemplate(boolean b) {
        this.hasTemplate = b;
        return this;
    }

    public String portId() {
        return this.router().portId();
    }

    public int port() {
        return this.router().port();
    }

    public UserAgent userAgent() {
        if (null == this.ua) {
            this.ua = UserAgent.parse((String)this.req().header("User-Agent"));
        }
        return this.ua;
    }

    public boolean jsonEncoded() {
        return this.req().contentType() == H.Format.JSON;
    }

    public boolean acceptJson() {
        return this.accept() == H.Format.JSON;
    }

    public boolean acceptXML() {
        return this.accept() == H.Format.XML;
    }

    public boolean isAjax() {
        return this.req().isAjax();
    }

    public boolean isOptionsMethod() {
        return this.req().method() == H.Method.OPTIONS;
    }

    public String username() {
        return this.session().get(this.sessionKeyUsername);
    }

    public boolean isLoggedIn() {
        return S.notBlank((String)this.username());
    }

    public String body() {
        return this.paramVal(REQ_BODY);
    }

    public ActionContext param(String name, String value) {
        this.extraParams.put(name, value);
        return this;
    }

    public Set<String> paramKeys() {
        HashSet<String> set = new HashSet<String>();
        set.addAll((Collection<String>)C.list((Iterable)this.request.paramNames()));
        set.addAll(this.extraParams.keySet());
        set.addAll(this.bodyParams().keySet());
        return set;
    }

    public String paramVal(String name) {
        String[] sa;
        String val = this.extraParams.get(name);
        if (null != val) {
            return val;
        }
        val = this.request.paramVal(name);
        if (null == val && null != (sa = this.getBody(name)) && sa.length > 0) {
            val = sa[0];
        }
        return val;
    }

    public String[] paramVals(String name) {
        String val = this.extraParams.get(name);
        if (null != val) {
            return new String[]{val};
        }
        String[] sa = this.request.paramVals(name);
        if (null == sa) {
            sa = this.getBody(name);
        }
        return sa;
    }

    private String[] getBody(String name) {
        Map<String, String[]> body = this.bodyParams();
        return body.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String[]> bodyParams() {
        if (null == this.bodyParams) {
            ActionContext actionContext = this;
            synchronized (actionContext) {
                if (null == this.bodyParams) {
                    Object map = C.newMap((Object[])new Object[0]);
                    H.Method method = this.request.method();
                    if (H.Method.POST == method || H.Method.PUT == method || H.Method.PATCH == method) {
                        RequestBodyParser parser = RequestBodyParser.get(this.request);
                        map = parser.parse(this);
                    }
                    this.bodyParams = map;
                }
            }
        }
        return this.bodyParams;
    }

    public Map<String, String[]> allParams() {
        return this.allParams;
    }

    public ISObject upload(String name) {
        Integer index = (Integer)this.attribute(ATTR_CURRENT_FILE_INDEX);
        if (null == index) {
            index = 0;
        }
        return this.upload(name, index);
    }

    public ISObject upload(String name, int index) {
        this.body();
        ISObject[] a = this.uploads.get(name);
        return null != a && a.length > index ? a[index] : null;
    }

    public ActionContext addUpload(String name, ISObject sobj) {
        ISObject[] a = this.uploads.get(name);
        if (null == a) {
            a = new ISObject[]{sobj};
        } else {
            ISObject[] newA = new ISObject[a.length + 1];
            System.arraycopy(a, 0, newA, 0, a.length);
            newA[a.length] = sobj;
            a = newA;
        }
        this.uploads.put(name, a);
        return this;
    }

    public H.Status successStatus() {
        if (null != this.forceResponseStatus) {
            return this.forceResponseStatus;
        }
        return H.Method.POST == this.req().method() ? H.Status.CREATED : H.Status.OK;
    }

    public ActionContext forceResponseStatus(H.Status status) {
        this.forceResponseStatus = (H.Status)$.notNull((Object)status);
        return this;
    }

    public Result nullValueResult() {
        if (null != this.forceResponseStatus) {
            return new Result(this.forceResponseStatus){};
        }
        if (this.req().method() == H.Method.POST) {
            H.Format accept = this.accept();
            if (H.Format.JSON == accept) {
                return Controller.Util.CREATED_JSON;
            }
            if (H.Format.XML == accept) {
                return Controller.Util.CREATED_XML;
            }
            return Controller.Util.CREATED;
        }
        return Controller.Util.NO_CONTENT;
    }

    public void preCheckCsrf() {
        if (!this.disableCsrf) {
            this.handler().csrfSpec().preCheck(this);
        }
    }

    public void checkCsrf(H.Session session) {
        if (!this.disableCsrf) {
            this.handler().csrfSpec().check(this, session);
        }
    }

    public void setCsrfCookieAndRenderArgs() {
        this.handler().csrfSpec().setCookieAndRenderArgs(this);
    }

    public void disableCORS() {
        this.disableCors = true;
    }

    public ActionContext applyContentType() {
        H.Request req = this.req();
        H.Format fmt = req.accept();
        if (H.Format.UNKNOWN == fmt) {
            fmt = req.contentType();
        }
        this.resp().addHeaderIfNotAdded("Content-Type", fmt.contentType());
        return this;
    }

    public ActionContext applyCorsSpec() {
        CORS.Spec spec = this.handler().corsSpec();
        spec.applyTo(this);
        this.applyGlobalCorsSetting();
        return this;
    }

    private void applyGlobalCorsSetting() {
        if (this.disableCors) {
            return;
        }
        AppConfig conf = this.config();
        if (!conf.corsEnabled()) {
            return;
        }
        H.Response r = this.resp();
        r.addHeaderIfNotAdded("Access-Control-Allow-Origin", conf.corsAllowOrigin());
        if (this.request.method() == H.Method.OPTIONS || !conf.corsOptionCheck().booleanValue()) {
            r.addHeaderIfNotAdded("Access-Control-Allow-Headers", conf.corsAllowHeaders());
            r.addHeaderIfNotAdded("Access-Control-Expose-Headers", conf.corsExposeHeaders());
            r.addHeaderIfNotAdded("Access-Control-Max-Age", S.string((Object)conf.corsMaxAge()));
        }
    }

    public ActionContext __appRenderArgNames(String names) {
        return this.renderArg("__arg_names__", C.listOf((Object[])names.split(",")));
    }

    public List<String> __appRenderArgNames() {
        return (List)this.renderArg("__arg_names__");
    }

    public ActionContext __controllerInstance(String className, Object instance) {
        if (null == this.controllerInstances) {
            this.controllerInstances = C.newMap((Object[])new Object[0]);
        }
        this.controllerInstances.put(className, instance);
        return this;
    }

    public Object __controllerInstance(String className) {
        return null == this.controllerInstances ? null : this.controllerInstances.get(className);
    }

    public <T> T cached(String key) {
        H.Session sess = this.session();
        if (null != sess) {
            return (T)sess.cached(key);
        }
        return (T)this.app().cache().get(key);
    }

    public void cache(String key, Object obj) {
        H.Session sess = this.session();
        if (null != sess) {
            sess.cache(key, obj);
        } else {
            this.app().cache().put(key, obj);
        }
    }

    public void cache(String key, Object obj, int expiration) {
        H.Session session = this.session;
        if (null != session) {
            session.cache(key, obj, expiration);
        } else {
            this.app().cache().put(key, obj, expiration);
        }
    }

    public void cacheForOneHour(String key, Object obj) {
        this.cache(key, obj, 3600);
    }

    public void cacheForHalfHour(String key, Object obj) {
        this.cache(key, obj, 1800);
    }

    public void cacheForTenMinutes(String key, Object obj) {
        this.cache(key, obj, 600);
    }

    public void cacheForOneMinute(String key, Object obj) {
        this.cache(key, obj, 60);
    }

    public void evictCache(String key) {
        H.Session sess = this.session();
        if (null != sess) {
            sess.evict(key);
        } else {
            this.app().cache().evict(key);
        }
    }

    public S.Buffer buildViolationMessage(S.Buffer builder) {
        return this.buildViolationMessage(builder, "\n");
    }

    public S.Buffer buildViolationMessage(S.Buffer builder, String separator) {
        Map<String, ConstraintViolation> violations = this.violations();
        if (violations.isEmpty()) {
            return builder;
        }
        for (Map.Entry<String, ConstraintViolation> entry : violations.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue().getMessage()).append(separator);
        }
        int n = builder.length();
        builder.delete(n - separator.length(), n);
        return builder;
    }

    public String violationMessage(String separator) {
        return this.buildViolationMessage(S.newBuffer(), separator).toString();
    }

    public String violationMessage() {
        return this.violationMessage("\n");
    }

    public ActionContext flashViolationMessage() {
        return this.flashViolationMessage("\n");
    }

    public ActionContext flashViolationMessage(String separator) {
        if (this.violations().isEmpty()) {
            return this;
        }
        this.flash().error(this.violationMessage(separator));
        return this;
    }

    public String actionPath() {
        return this.actionPath;
    }

    public ActionContext actionPath(String path) {
        this.actionPath = path;
        return this;
    }

    @Override
    public String methodPath() {
        return this.actionPath;
    }

    @Override
    public String templatePath() {
        String path = super.templatePath();
        if (S.notBlank((String)path)) {
            return path;
        }
        return this.actionPath().replace('.', '/');
    }

    public void startIntercepting() {
        this.state = State.INTERCEPTING;
    }

    public void startHandling() {
        this.state = State.HANDLING;
    }

    public void login(String username) {
        this.session().put(this.config().sessionKeyUsername(), username);
    }

    public void logout() {
        this.session().clear();
    }

    public void resolve() {
        E.illegalStateIf((this.state != State.CREATED ? 1 : 0) != 0);
        boolean sessionFree = this.handler.sessionFree();
        this.attribute(ATTR_WAS_UNAUTHENTICATED, true);
        if (!sessionFree) {
            this.resolveSession();
            this.resolveFlash();
        }
        this.localeResolver.resolve();
        this.state = State.SESSION_RESOLVED;
        if (!sessionFree) {
            EventBus eventBus = this.app().eventBus();
            eventBus.emit(new PreFireSessionResolvedEvent(this.session, this));
            Act.sessionManager().fireSessionResolved(this);
            eventBus.emit(new SessionResolvedEvent(this.session, this));
            if (this.isLoggedIn()) {
                this.attribute(ATTR_WAS_UNAUTHENTICATED, false);
            }
        }
    }

    @Override
    public Locale locale(boolean required) {
        if (required && null == this.locale()) {
            this.localeResolver.resolve();
        }
        return super.locale(required);
    }

    public void dissolve() {
        if (this.state == State.SESSION_DISSOLVED) {
            return;
        }
        if (this.handler.sessionFree()) {
            return;
        }
        this.localeResolver.dissolve();
        this.app().eventBus().emit(new SessionWillDissolveEvent(this));
        try {
            this.dissolveFlash();
            this.dissolveSession();
            this.state = State.SESSION_DISSOLVED;
        }
        finally {
            this.app().eventBus().emit(new SessionDissolvedEvent(this));
        }
    }

    @Override
    protected void releaseResources() {
        super.releaseResources();
        PropertySpec.current.remove();
        if (this.state != State.DESTROYED) {
            this.allParams = null;
            this.extraParams = null;
            this.requestParamCache = null;
            this.router = null;
            this.handler = null;
            this.flash = null;
            this.session = null;
            this.controllerInstances = null;
            ActionContext.clearLocal();
            this.uploads.clear();
        }
        this.state = State.DESTROYED;
    }

    public void saveLocal() {
        _local.set((Object)this);
    }

    public static void clearLocal() {
        _local.remove();
    }

    private Set<Map.Entry<String, String[]>> requestParamCache() {
        if (null != this.requestParamCache) {
            return this.requestParamCache;
        }
        this.requestParamCache = new HashSet<Map.Entry<String, String[]>>();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (String key : this.request.paramNames()) {
            String[] val = this.request.paramVals(key);
            MapUtil.mergeValueInMap(map, key, val);
        }
        Map<String, String[]> map2 = this.bodyParams();
        for (String key : map2.keySet()) {
            String[] val = map2.get(key);
            if (null == val) continue;
            MapUtil.mergeValueInMap(map, key, val);
        }
        this.requestParamCache.addAll(map.entrySet());
        return this.requestParamCache;
    }

    private void _init() {
        this.uploads = new HashMap<String, ISObject[]>();
        this.extraParams = new HashMap<String, String>();
        final AbstractSet<Map.Entry<String, String[]>> paramEntrySet = new AbstractSet<Map.Entry<String, String[]>>(){

            @Override
            public Iterator<Map.Entry<String, String[]>> iterator() {
                final Iterator<Map.Entry<String, String[]>> extraItr = new Iterator<Map.Entry<String, String[]>>(){
                    Iterator<Map.Entry<String, String>> parent;
                    {
                        this.parent = ActionContext.this.extraParams.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.parent.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String[]> next() {
                        final Map.Entry<String, String> parentEntry = this.parent.next();
                        return new Map.Entry<String, String[]>(){

                            @Override
                            public String getKey() {
                                return (String)parentEntry.getKey();
                            }

                            @Override
                            public String[] getValue() {
                                return new String[]{(String)parentEntry.getValue()};
                            }

                            @Override
                            public String[] setValue(String[] value) {
                                throw E.unsupport();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw E.unsupport();
                    }
                };
                final Iterator reqParamItr = ActionContext.this.requestParamCache().iterator();
                return new Iterator<Map.Entry<String, String[]>>(){

                    @Override
                    public boolean hasNext() {
                        return extraItr.hasNext() || reqParamItr.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String[]> next() {
                        if (extraItr.hasNext()) {
                            return (Map.Entry)extraItr.next();
                        }
                        return (Map.Entry)reqParamItr.next();
                    }

                    @Override
                    public void remove() {
                        throw E.unsupport();
                    }
                };
            }

            @Override
            public int size() {
                int size = ActionContext.this.extraParams.size();
                if (null != ActionContext.this.request) {
                    size += ActionContext.this.requestParamCache().size();
                }
                return size;
            }
        };
        this.allParams = new AbstractMap<String, String[]>(){

            @Override
            public Set<Map.Entry<String, String[]>> entrySet() {
                return paramEntrySet;
            }
        };
    }

    private void resolveSession() {
        this.session = Act.sessionManager().resolveSession(this);
    }

    private void resolveFlash() {
        this.flash = Act.sessionManager().resolveFlash(this);
    }

    private void dissolveSession() {
        H.Cookie c = Act.sessionManager().dissolveSession(this);
        if (null != c) {
            this.config().sessionMapper().serializeSession(c, this);
        }
    }

    private void dissolveFlash() {
        H.Cookie c = Act.sessionManager().dissolveFlash(this);
        if (null != c) {
            this.config().sessionMapper().serializeFlash(c, this);
        }
    }

    public static ActionContext current() {
        return (ActionContext)_local.get();
    }

    public static void clearCurrent() {
        _local.remove();
    }

    public static ActionContext create(App app, H.Request request, H.Response resp) {
        return new ActionContext(app, request, resp);
    }

    public static class SessionDissolvedEvent
    extends ActionContextEvent {
        public SessionDissolvedEvent(ActionContext source) {
            super(source);
        }
    }

    public static class SessionWillDissolveEvent
    extends ActionContextEvent {
        public SessionWillDissolveEvent(ActionContext source) {
            super(source);
        }
    }

    public static class SessionResolvedEvent
    extends SessionEvent {
        public SessionResolvedEvent(H.Session session, ActionContext context) {
            super(session, context);
        }
    }

    public static class PreFireSessionResolvedEvent
    extends SessionEvent {
        public PreFireSessionResolvedEvent(H.Session session, ActionContext context) {
            super(session, context);
        }
    }

    private static class SessionEvent
    extends ActionContextEvent {
        private H.Session session;

        public SessionEvent(H.Session session, ActionContext source) {
            super(source);
            this.session = session;
        }

        public H.Session session() {
            return this.session;
        }
    }

    public static class ActionContextEvent
    extends ActEvent<ActionContext>
    implements SystemEvent {
        public ActionContextEvent(ActionContext source) {
            super(source);
        }

        public ActionContext context() {
            return (ActionContext)this.source();
        }
    }

    public static enum State {
        CREATED,
        SESSION_RESOLVED,
        SESSION_DISSOLVED,
        INTERCEPTING,
        HANDLING,
        DESTROYED;


        public boolean isHandling() {
            return this == HANDLING;
        }

        public boolean isIntercepting() {
            return this == INTERCEPTING;
        }
    }
}

