/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.ActionContext;
import act.app.AppBuilder;
import act.app.AppClassLoader;
import act.app.AppCodeScannerManager;
import act.app.AppInterceptorManager;
import act.app.AppService;
import act.app.AppServiceRegistry;
import act.app.CliServer;
import act.app.CompilationException;
import act.app.Daemon;
import act.app.DbServiceManager;
import act.app.ProjectLayout;
import act.app.RequestRefreshClassLoader;
import act.app.RequestServerRestart;
import act.app.RuntimeDirs;
import act.app.SingletonRegistry;
import act.app.data.BinderManager;
import act.app.data.StringValueResolverManager;
import act.app.event.AppEventId;
import act.app.util.AppCrypto;
import act.app.util.NamedPort;
import act.boot.BootstrapClassLoader;
import act.cli.CliDispatcher;
import act.cli.bytecode.CommanderByteCodeScanner;
import act.conf.AppConfLoader;
import act.conf.AppConfig;
import act.conf.AppConfigKey;
import act.controller.bytecode.ControllerByteCodeScanner;
import act.data.DataPropertyRepository;
import act.data.JodaDateTimeCodec;
import act.data.util.ActPropertyHandlerFactory;
import act.event.AppEventListenerBase;
import act.event.EventBus;
import act.event.bytecode.SimpleEventListenerByteCodeScanner;
import act.handler.RequestHandler;
import act.handler.builtin.StaticResourceGetter;
import act.handler.builtin.controller.FastRequestHandler;
import act.inject.DependencyInjectionBinder;
import act.inject.DependencyInjector;
import act.inject.genie.GenieInjector;
import act.inject.genie.GenieModuleScanner;
import act.inject.param.JsonDTOClassManager;
import act.inject.param.ParamValueLoaderManager;
import act.job.AppJobManager;
import act.job.bytecode.JobByteCodeScanner;
import act.mail.MailerConfigManager;
import act.mail.bytecode.MailerByteCodeScanner;
import act.route.RouteSource;
import act.route.RouteTableRouterBuilder;
import act.route.Router;
import act.util.ClassFinderByteCodeScanner;
import act.util.ClassInfoByteCodeScanner;
import act.util.DestroyableBase;
import act.util.IdGenerator;
import act.util.JsonUtilConfig;
import act.util.SimpleBean;
import act.util.SysProps;
import act.util.UploadFileStorageService;
import act.view.ActErrorResult;
import act.view.rythm.JodaDateTimeFormatter;
import act.view.rythm.JodaTransformers;
import act.view.rythm.RythmTransformerScanner;
import act.view.rythm.RythmView;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.http.H;
import org.osgl.http.HttpConfig;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.MvcConfig;
import org.osgl.mvc.result.Result;
import org.osgl.storage.IStorageService;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;
import org.osgl.util.ValueObject;
import org.rythmengine.utils.I18N;

public class App
extends DestroyableBase {
    @Deprecated
    public static final Logger logger = Act.LOGGER;
    public static final Logger LOGGER = Act.LOGGER;
    private static App INST;
    private volatile String profile;
    private String name;
    private File appBase;
    private File appHome;
    private Router router;
    private CliDispatcher cliDispatcher;
    private Map<NamedPort, Router> moreRouters;
    private AppConfig<?> config;
    private AppClassLoader classLoader;
    private ProjectLayout layout;
    private AppBuilder builder;
    private EventBus eventBus;
    private AppCodeScannerManager scannerManager;
    private DbServiceManager dbServiceManager;
    private AppJobManager jobManager;
    private CliServer cliServer;
    private MailerConfigManager mailerConfigManager;
    private StringValueResolverManager resolverManager;
    private SingletonRegistry singletonRegistry;
    private BinderManager binderManager;
    private AppInterceptorManager interceptorManager;
    private DependencyInjector<?> dependencyInjector;
    private IStorageService uploadFileStorageService;
    private AppServiceRegistry appServiceRegistry;
    private Map<String, Daemon> daemonRegistry;
    private AppCrypto crypto;
    private IdGenerator idGenerator;
    private CacheService cache;
    private CompilationException compilationException;
    private AppEventId currentState;
    private Set<AppEventId> eventEmitted;
    private Thread mainThread;
    private Set<String> scanList;
    private List<File> baseDirs;
    private volatile File tmpDir;
    private boolean restarting;
    private Result blockIssue;
    private Exception blockIssueCause;
    private RequestHandler blockIssueHandler = new FastRequestHandler(){

        @Override
        public void handle(ActionContext context) {
            E.illegalArgumentIf((null == App.this.blockIssue ? 1 : 0) != 0);
            App.this.blockIssue.apply(context.req(), context.resp());
        }
    };

    protected App() {
        INST = this;
    }

    protected App(File appBase, ProjectLayout layout) {
        this("MyApp", appBase, layout);
    }

    protected App(String name, File appBase, ProjectLayout layout) {
        this.name = name;
        this.appBase = appBase;
        this.layout = layout;
        this.appHome = RuntimeDirs.home(this);
        INST = this;
    }

    public static App instance() {
        return INST;
    }

    App name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String profile() {
        if (null == this.profile) {
            App app = this;
            synchronized (app) {
                if (null == this.profile) {
                    String s = SysProps.get(AppConfigKey.PROFILE.key());
                    if (null == s) {
                        s = Act.mode().name().toLowerCase();
                    }
                    this.profile = s;
                }
            }
        }
        return this.profile;
    }

    public Act.Mode mode() {
        return Act.mode();
    }

    public boolean isDev() {
        return this.mode().isDev();
    }

    public boolean isProd() {
        return this.mode().isProd();
    }

    public AppConfig<?> config() {
        return this.config;
    }

    public List<File> baseDirs() {
        if (null == this.baseDirs) {
            this.baseDirs = C.newList();
            if (null != this.appBase && this.appBase.isDirectory()) {
                this.baseDirs.add(this.appBase);
            }
            for (File baseDir : this.config.moduleBases()) {
                if (null == baseDir || !baseDir.isDirectory()) continue;
                this.baseDirs.add(baseDir);
            }
        }
        return this.baseDirs;
    }

    public List<File> sourceDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.SRC.curry((Object)this.layout()));
    }

    public List<File> resourceDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.RSRC.curry((Object)this.layout()));
    }

    public List<File> libDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.LIB.curry((Object)this.layout()));
    }

    public List<File> testSourceDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.TST_SRC.curry((Object)this.layout()));
    }

    public List<File> testResourceDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.TST_RSRC.curry((Object)this.layout()));
    }

    public List<File> testLibDirs() {
        return this.layoutDirs((Osgl.Function<File, File>)ProjectLayout.F.TST_LIB.curry((Object)this.layout()));
    }

    public List<File> allSourceDirs(boolean requireTestProfile) {
        C.List dirs = C.newList();
        dirs.addAll(this.sourceDirs());
        if (!requireTestProfile || "test".equals(Act.profile())) {
            dirs.addAll(this.testSourceDirs());
        }
        return dirs;
    }

    public List<File> allResourceDirs(boolean requireTestProfile) {
        C.List dirs = C.newList();
        dirs.addAll(this.resourceDirs());
        if (!requireTestProfile || "test".equals(Act.profile())) {
            dirs.addAll(this.testResourceDirs());
        }
        return dirs;
    }

    public List<File> allLibDirs(boolean requireTestProfile) {
        C.List dirs = C.newList();
        dirs.addAll(this.libDirs());
        if (!requireTestProfile || "test".equals(Act.profile())) {
            dirs.addAll(this.testLibDirs());
        }
        return dirs;
    }

    private List<File> layoutDirs(Osgl.Function<File, File> transformer) {
        return C.list(this.baseDirs()).map(transformer);
    }

    public CliDispatcher cliDispatcher() {
        return this.cliDispatcher;
    }

    public Router router() {
        return this.router;
    }

    public Router router(String name) {
        if (S.blank((String)name)) {
            return this.router();
        }
        for (Map.Entry<NamedPort, Router> entry : this.moreRouters.entrySet()) {
            if (!S.eq((String)entry.getKey().name(), (String)name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Router router(NamedPort port) {
        if (null == port) {
            return this.router();
        }
        return this.moreRouters.get(port);
    }

    public AppCrypto crypto() {
        return this.crypto;
    }

    public File base() {
        return this.appBase;
    }

    public File home() {
        return this.appHome;
    }

    public AppClassLoader classLoader() {
        return this.classLoader;
    }

    public ProjectLayout layout() {
        return this.layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdates(boolean async) {
        if (!Act.isDev()) {
            return;
        }
        App app = this;
        synchronized (app) {
            try {
                this.detectChanges();
            }
            catch (RequestRefreshClassLoader refreshRequest) {
                this.refresh(async);
            }
            catch (RequestServerRestart requestServerRestart) {
                this.refresh(async);
            }
        }
    }

    public synchronized void detectChanges() {
        if (null == this.classLoader) {
            throw new RequestServerRestart();
        }
        this.classLoader.detectChanges();
        if (null != this.compilationException) {
            throw ActErrorResult.of((Throwable)((Object)this.compilationException));
        }
    }

    public void restart() {
        this.build();
        this.refresh();
    }

    public synchronized void setBlockIssue(Exception e) {
        if (e instanceof ActErrorResult) {
            this.blockIssue = (ActErrorResult)((Object)e);
        } else if (null != this.classLoader()) {
            this.blockIssue = ActErrorResult.of(e);
            this.blockIssueCause = null;
        } else {
            this.blockIssueCause = e;
        }
    }

    public void asyncRefresh() {
        new Thread(){

            @Override
            public void run() {
                App.this.refresh();
            }
        }.start();
    }

    public boolean isStarted() {
        return this.currentState == AppEventId.POST_START || this.currentState == AppEventId.ACT_START;
    }

    public boolean isMainThread() {
        return Thread.currentThread() == this.mainThread;
    }

    public void shutdown() {
        Act.shutdownApp(this);
    }

    @Override
    protected void releaseResources() {
        this.mainThread.interrupt();
        if (null == this.daemonRegistry) {
            return;
        }
        LOGGER.info("App shutting down ....");
        if (null != this.classLoader && this.config().i18nEnabled()) {
            ResourceBundle.clearCache(this.classLoader);
            ResourceBundle.clearCache(I18N.class.getClassLoader());
        }
        for (Daemon d : this.daemonRegistry.values()) {
            this.stopDaemon(d);
        }
        this.shutdownCliServer();
        this.shutdownEventBus();
        this.shutdownJobManager();
        this.clearServiceResourceManager();
        this.classLoader = null;
    }

    public synchronized void refresh(boolean async) {
        if (async) {
            this.asyncRefresh();
        } else {
            this.refresh();
        }
    }

    public synchronized boolean isRestarting() {
        return this.restarting;
    }

    public RequestHandler blockIssueHandler() {
        if (null != this.blockIssue && Act.isDev()) {
            return this.blockIssueHandler;
        }
        return null;
    }

    public synchronized void refresh() {
        this.currentState = null;
        long ms = $.ms();
        LOGGER.info("App starting ....");
        this.profile = null;
        this.blockIssue = null;
        this.blockIssueCause = null;
        this.initScanlist();
        this.initServiceResourceManager();
        this.reload();
        this.mainThread = Thread.currentThread();
        this.restarting = this.mainThread.getName().contains("job");
        this.eventEmitted = C.newSet();
        this.initSingletonRegistry();
        this.initEventBus();
        this.emit(AppEventId.EVENT_BUS_INITIALIZED);
        this.loadConfig();
        this.emit(AppEventId.CONFIG_LOADED);
        this.initCache();
        this.initDataPropertyRepository();
        this.initCrypto();
        this.initIdGenerator();
        this.initJobManager();
        this.initDaemonRegistry();
        this.initInterceptorManager();
        this.initResolverManager();
        this.initBinderManager();
        this.initUploadFileStorageService();
        this.initRouters();
        this.emit(AppEventId.ROUTER_INITIALIZED);
        this.loadRoutes();
        this.emit(AppEventId.ROUTER_LOADED);
        this.initCliDispatcher();
        this.initCliServer();
        this.initDbServiceManager();
        this.emit(AppEventId.DB_SVC_LOADED);
        Act.viewManager().reset();
        this.loadGlobalPlugin();
        this.emit(AppEventId.APP_ACT_PLUGIN_LOADED);
        this.initScannerManager();
        this.loadActScanners();
        this.loadBuiltInScanners();
        this.emit(AppEventId.PRE_LOAD_CLASSES);
        this.initClassLoader();
        this.emit(AppEventId.CLASS_LOADER_INITIALIZED);
        this.preloadClasses();
        try {
            this.scanAppCodes();
            this.compilationException = null;
        }
        catch (CompilationException e) {
            this.compilationException = e;
            throw ActErrorResult.of((Throwable)((Object)e));
        }
        this.emit(AppEventId.APP_CODE_SCANNED);
        this.emit(AppEventId.CLASS_LOADED);
        Act.viewManager().reload(this);
        this.loadDependencyInjector();
        this.emit(AppEventId.DEPENDENCY_INJECTOR_LOADED);
        this.initJsonDTOClassManager();
        this.initParamValueLoaderManager();
        this.initMailerConfigManager();
        this.initHttpConfig();
        this.initViewManager();
        this.emit(AppEventId.DEPENDENCY_INJECTOR_PROVISIONED);
        this.emit(AppEventId.SINGLETON_PROVISIONED);
        this.config().preloadConfigurations();
        this.emit(AppEventId.PRE_START);
        this.emit(AppEventId.START);
        this.daemonKeeper();
        if (null != this.blockIssueCause) {
            this.setBlockIssue(this.blockIssueCause);
        }
        LOGGER.info("App[%s] loaded in %sms", new Object[]{this.name(), $.ms() - ms});
        this.emit(AppEventId.POST_START);
    }

    public AppBuilder builder() {
        return this.builder;
    }

    void build() {
        this.builder = AppBuilder.build(this);
    }

    void hook() {
        Act.hook(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File tmpDir() {
        if (null == this.tmpDir) {
            App app = this;
            synchronized (app) {
                if (Act.isDev()) {
                    this.tmpDir = new File(this.layout().target(this.appBase), "tmp");
                } else {
                    try {
                        this.tmpDir = Files.createTempDirectory(this.name(), new FileAttribute[0]).toFile();
                    }
                    catch (IOException e) {
                        throw E.ioException((IOException)e);
                    }
                }
            }
        }
        return this.tmpDir;
    }

    public File file(String path) {
        return new File(this.base(), path);
    }

    public File resource(String path) {
        return new File(this.layout().resource(this.appBase), path);
    }

    public void registerDaemon(Daemon daemon) {
        this.daemonRegistry.put(daemon.id(), daemon);
    }

    public void unregisterDaemon(Daemon daemon) {
        this.daemonRegistry.remove(daemon.id());
    }

    List<Daemon> registeredDaemons() {
        return C.list(this.daemonRegistry.values());
    }

    Daemon registeredDaemon(String id) {
        return this.daemonRegistry.get(id);
    }

    public <T> void registerSingleton(Class<? extends T> cls, T instance) {
        if (null != this.singletonRegistry) {
            this.singletonRegistry.register(cls, instance);
        }
    }

    public void registerSingletonClass(Class<?> aClass) {
        this.singletonRegistry.register(aClass);
    }

    public void registerSingleton(Object instance) {
        this.singletonRegistry.register(instance.getClass(), instance);
    }

    public AppInterceptorManager interceptorManager() {
        return this.interceptorManager;
    }

    public AppCodeScannerManager scannerManager() {
        return this.scannerManager;
    }

    public DbServiceManager dbServiceManager() {
        return this.dbServiceManager;
    }

    public StringValueResolverManager resolverManager() {
        return this.resolverManager;
    }

    public BinderManager binderManager() {
        return this.binderManager;
    }

    public CacheService cache() {
        return this.cache;
    }

    public CacheService cache(String name) {
        return this.config().cacheService(name);
    }

    public MailerConfigManager mailerConfigManager() {
        return this.mailerConfigManager;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public AppJobManager jobManager() {
        return this.jobManager;
    }

    public <DI extends DependencyInjector> App injector(DI dependencyInjector) {
        E.NPE(dependencyInjector);
        E.illegalStateIf((null != this.dependencyInjector ? 1 : 0) != 0, (String)"Dependency injection factory already set");
        this.dependencyInjector = dependencyInjector;
        return this;
    }

    public <DI extends DependencyInjector> DI injector() {
        return (DI)this.dependencyInjector;
    }

    public IStorageService uploadFileStorageService() {
        return this.uploadFileStorageService;
    }

    public String sign(String message) {
        return this.crypto().sign(message);
    }

    public String encrypt(String message) {
        return this.crypto().encrypt(message);
    }

    public String decrypt(String message) {
        return this.crypto().decrypt(message);
    }

    public <T> T singleton(Class<T> clz) {
        return this.singletonRegistry.get(clz);
    }

    public <T> T getInstance(String className) {
        Class c = $.classForName((String)className, (ClassLoader)this.classLoader());
        return this.getInstance(c);
    }

    public <T> T getInstance(Class<T> clz) {
        if (null == this.dependencyInjector) {
            return (T)$.newInstance(clz);
        }
        return this.dependencyInjector.get(clz);
    }

    public int hashCode() {
        return this.appBase.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof App) {
            App that = (App)obj;
            return $.eq((Object)that.appBase, (Object)this.appBase);
        }
        return false;
    }

    public String toString() {
        String path = this.appBase.getPath();
        return S.concat((String)"app@[", (String)path, (String)"]");
    }

    public String cuid() {
        return this.idGenerator.genId();
    }

    public <T extends AppService<T>> T service(Class<T> serviceClass) {
        return this.appServiceRegistry.lookup(serviceClass);
    }

    App register(AppService service) {
        return this.register(service, false);
    }

    App register(final AppService service, boolean noDiBinder) {
        if (null == this.appServiceRegistry) {
            return this;
        }
        this.appServiceRegistry.register(service);
        if (null != this.eventBus && !noDiBinder) {
            this.eventBus.bind(AppEventId.DEPENDENCY_INJECTOR_LOADED, new AppEventListenerBase(){

                @Override
                public void on(EventObject event) throws Exception {
                    App app = App.this;
                    App.this.eventBus.emit(new DependencyInjectionBinder(app, service.getClass()){

                        public Object resolve(App app) {
                            return app.service(service.getClass());
                        }
                    });
                }
            });
        }
        return this;
    }

    public void emit(AppEventId appEvent) {
        this.currentState = appEvent;
        this.eventEmitted().add(appEvent);
        EventBus bus = this.eventBus();
        if (null != bus) {
            bus.emit(appEvent);
        }
    }

    public Set<String> scanList() {
        return new HashSet<String>(this.scanList);
    }

    private Set<AppEventId> eventEmitted() {
        return this.eventEmitted;
    }

    public boolean eventEmitted(AppEventId appEvent) {
        return this.eventEmitted().contains((Object)appEvent);
    }

    public AppEventId currentState() {
        return this.currentState;
    }

    private void loadConfig() {
        JsonUtilConfig.configure(this);
        File conf = RuntimeDirs.conf(this);
        logger.debug("loading app configuration: %s ...", new Object[]{this.appBase.getAbsolutePath()});
        this.config = (AppConfig)new AppConfLoader().load(conf);
        this.config.app(this);
        this.configureLoggingLevels();
        this.registerSingleton(AppConfig.class, this.config);
        this.registerValueObjectCodec();
        if (this.config.i18nEnabled()) {
            MvcConfig.enableLocalizedErrorMsg();
        }
    }

    private void initHttpConfig() {
        HttpConfig.secure((boolean)this.config.httpSecure());
        HttpConfig.securePort((int)this.config.httpExternalSecurePort());
        HttpConfig.nonSecurePort((int)this.config.httpExternalPort());
        HttpConfig.defaultLocale((Locale)this.config.locale());
        HttpConfig.domain((String)this.config.host());
    }

    private void registerValueObjectCodec() {
        ValueObject.register((ValueObject.Codec)new JodaDateTimeCodec(this.config));
    }

    private void initIdGenerator() {
        this.idGenerator = new IdGenerator(this.config().nodeIdProvider(), this.config().startIdProvider(), this.config().sequenceProvider(), this.config().longEncoder());
    }

    private void initDaemonRegistry() {
        if (null != this.daemonRegistry) {
            Destroyable.Util.tryDestroyAll(this.daemonRegistry.values(), ApplicationScoped.class);
        }
        this.daemonRegistry = C.newMap((Object[])new Object[0]);
        this.jobManager.on(AppEventId.START, new Runnable(){

            @Override
            public void run() {
                App.this.jobManager.fixedDelay("daemon-keeper", new Runnable(){

                    @Override
                    public void run() {
                        App.this.daemonKeeper();
                    }
                }, "1mn");
            }
        });
    }

    private void daemonKeeper() {
        String KEY_COUNTER = "c";
        String KEY_SEQ_NO = "sn";
        String KEY_LAST_SEQ_NO = "lsn";
        for (Daemon d : this.daemonRegistry.values()) {
            Integer lastSeqNo;
            Integer seqNo;
            Daemon.State state = d.state();
            if (state == Daemon.State.STARTED) {
                if (d.getAttribute("c") == null) continue;
                d.removeAttribute("c");
                d.removeAttribute("sn");
                d.removeAttribute("lsn");
                continue;
            }
            if (state == Daemon.State.STOPPED) {
                this.startDaemon(d);
                continue;
            }
            if (state != Daemon.State.ERROR) continue;
            Integer counter = (Integer)d.getAttribute("c");
            if (null == counter) {
                counter = 1;
                seqNo = 1;
                lastSeqNo = 0;
            } else {
                seqNo = (Integer)d.getAttribute("sn");
                lastSeqNo = (Integer)d.getAttribute("lsn");
            }
            counter = counter - 1;
            if (counter == 0) {
                this.startDaemon(d);
                int nextSeqNo = seqNo + lastSeqNo;
                lastSeqNo = seqNo;
                counter = seqNo = Integer.valueOf(nextSeqNo);
                d.setAttribute("sn", seqNo);
                d.setAttribute("lsn", lastSeqNo);
            }
            d.setAttribute("c", counter);
        }
    }

    private void startDaemon(final Daemon daemon) {
        this.jobManager().now(new Runnable(){

            @Override
            public void run() {
                try {
                    daemon.start();
                }
                catch (Exception e) {
                    logger.error((Throwable)e, "Error starting daemon [%s]", new Object[]{daemon.id()});
                }
            }
        });
    }

    private void stopDaemon(Daemon daemon) {
        daemon.stop();
    }

    private void initServiceResourceManager() {
        this.clearServiceResourceManager();
        this.appServiceRegistry = new AppServiceRegistry(this);
    }

    private void clearServiceResourceManager() {
        if (null != this.appServiceRegistry) {
            this.eventBus().emit(AppEventId.STOP);
            this.appServiceRegistry.destroy();
            this.dependencyInjector = null;
            if (null != this.cache) {
                this.cache.shutdown();
            }
        }
    }

    private void initUploadFileStorageService() {
        this.uploadFileStorageService = UploadFileStorageService.create(this);
    }

    private void initCliDispatcher() {
        if (this.config().cliEnabled()) {
            this.cliDispatcher = new CliDispatcher(this);
        }
    }

    private void initCliServer() {
        if (this.config().cliEnabled()) {
            this.cliServer = new CliServer(this);
        }
    }

    private void shutdownCliServer() {
        if (null != this.cliServer) {
            this.cliServer.destroy();
        }
    }

    private void initRouters() {
        this.router = new Router(this);
        this.moreRouters = C.newMap((Object[])new Object[0]);
        List<NamedPort> ports = this.config().namedPorts();
        for (NamedPort port : ports) {
            this.moreRouters.put(port, new Router(this, port.name()));
        }
        if (this.config.cliOverHttp()) {
            NamedPort cliOverHttp = new NamedPort("__admin__", this.config.cliOverHttpPort());
            this.moreRouters.put(cliOverHttp, new Router(this, "__admin__"));
        }
    }

    private void initEventBus() {
        this.eventBus = new EventBus(this);
    }

    public void shutdownEventBus() {
        if (null != this.eventBus) {
            this.eventBus.destroy();
        }
    }

    private void initCache() {
        this.cache = this.cache(this.config().cacheName());
        this.cache.startup();
        CacheService sessionCache = this.cache(this.config().cacheNameSession());
        if (this.cache != sessionCache) {
            sessionCache.startup();
        }
        HttpConfig.setSessionCache((CacheService)sessionCache);
    }

    private void initCrypto() {
        this.crypto = new AppCrypto(this.config());
        this.registerSingleton(AppCrypto.class, this.crypto);
    }

    private void initJobManager() {
        this.jobManager = new AppJobManager(this);
    }

    private void shutdownJobManager() {
        if (null != this.jobManager) {
            this.jobManager.destroy();
        }
    }

    private void initScanlist() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof BootstrapClassLoader) {
            this.scanList = ((BootstrapClassLoader)classLoader).scanList();
        }
    }

    private void initInterceptorManager() {
        this.interceptorManager = new AppInterceptorManager(this);
    }

    private void initScannerManager() {
        this.scannerManager = new AppCodeScannerManager(this);
    }

    private void initDbServiceManager() {
        this.dbServiceManager = new DbServiceManager(this);
    }

    private void initDataPropertyRepository() {
        new DataPropertyRepository(this);
    }

    private void initMailerConfigManager() {
        this.mailerConfigManager = new MailerConfigManager(this);
    }

    private void loadGlobalPlugin() {
        Act.appServicePluginManager().applyTo(this);
    }

    private void loadActScanners() {
        Act.scannerPluginManager().initApp(this);
    }

    private void loadBuiltInScanners() {
        this.scannerManager.register(new GenieModuleScanner());
        this.scannerManager.register(new ClassInfoByteCodeScanner());
        this.scannerManager.register(new ClassFinderByteCodeScanner());
        this.scannerManager.register(new ControllerByteCodeScanner());
        this.scannerManager.register(new MailerByteCodeScanner());
        this.scannerManager.register(new JobByteCodeScanner());
        this.scannerManager.register(new SimpleBean.ByteCodeScanner());
        this.scannerManager.register(new SimpleEventListenerByteCodeScanner());
        this.scannerManager.register(new CommanderByteCodeScanner());
        this.scannerManager.register(new RythmTransformerScanner());
    }

    private void loadDependencyInjector() {
        Object di = this.injector();
        if (null == di) {
            new GenieInjector(this);
        } else {
            logger.warn("Third party injector[%s] loaded. Please consider using Act air injection instead", new Object[]{di.getClass()});
        }
    }

    private void loadRoutes() {
        this.loadBuiltInRoutes();
        logger.debug("loading app routing table: %s ...", new Object[]{this.appBase.getPath()});
        File routes = Act.isProd() ? RuntimeDirs.routes(this) : this.layout().routeTable(this.base());
        if (!routes.isFile() || !routes.canRead()) {
            logger.debug("No route table find found");
            return;
        }
        List lines = IO.readLines((File)routes);
        new RouteTableRouterBuilder(lines).build(this.router);
    }

    private void loadBuiltInRoutes() {
        this.router().addMapping(H.Method.GET, (CharSequence)"/asset/", new StaticResourceGetter("asset"), RouteSource.BUILD_IN);
        this.router().addMapping(H.Method.GET, (CharSequence)"/asset/act/", new StaticResourceGetter("asset/act"), RouteSource.BUILD_IN);
        if (this.config().allowDownloadUploadFile()) {
            this.router().addMapping(H.Method.GET, (CharSequence)"/~upload/{path}", new UploadFileStorageService.UploadFileGetter(), RouteSource.BUILD_IN);
        }
        this.router().addContext("act.", "/~");
        if (this.config.cliOverHttp()) {
            Router router = this.router("__admin__");
            router.addMapping(H.Method.GET, (CharSequence)"/asset/", new StaticResourceGetter("asset"), RouteSource.BUILD_IN);
        }
    }

    private void initClassLoader() {
        this.classLoader = Act.mode().classLoader(this);
    }

    private void initJsonDTOClassManager() {
        new JsonDTOClassManager(this);
    }

    private void preloadClasses() {
        this.classLoader.preload();
    }

    private void initResolverManager() {
        this.resolverManager = new StringValueResolverManager(this);
        Osgl.propertyHandlerFactory = new ActPropertyHandlerFactory(this);
    }

    private void initBinderManager() {
        this.binderManager = new BinderManager(this);
    }

    private void initParamValueLoaderManager() {
        new ParamValueLoaderManager(this);
    }

    private void initSingletonRegistry() {
        this.singletonRegistry = new SingletonRegistry(this);
        this.singletonRegistry.register(App.class, this);
        this.appServiceRegistry.bulkRegisterSingleton();
    }

    private void loadPlugins() {
    }

    private void initViewManager() {
        Act.viewManager().onAppStart();
        this.registerBuiltInRythmTransformers();
    }

    private void registerBuiltInRythmTransformers() {
        RythmView rythmView = (RythmView)Act.viewManager().view("rythm");
        rythmView.registerBuiltInTransformer(this, JodaTransformers.class);
        rythmView.registerFormatter(this, new JodaDateTimeFormatter());
    }

    private void configureLoggingLevels() {
        Map map = this.config().subSet("log.level");
        map.putAll(this.config().subSet("act.log.level"));
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = (Map.Entry)$.cast(o);
            String key = (String)entry.getKey();
            key = key.startsWith("log.level") ? key.substring("log.level.".length()) : key.substring("act.log.level.".length());
            Logger.Level level = this.loggerLevelOf((String)entry.getValue());
            E.invalidConfigurationIf((null == level ? 1 : 0) != 0, (String)"Unknown log level: %s", (Object[])new Object[]{entry.getValue()});
            Logger logger = LogManager.get((String)key);
            logger.setLevel(level);
        }
    }

    private Logger.Level loggerLevelOf(String s) {
        HashMap<String, Logger.Level> map = new HashMap<String, Logger.Level>();
        for (Logger.Level level : Logger.Level.values()) {
            map.put(level.name().toUpperCase(), level);
        }
        map.put("WARNING", Logger.Level.WARN);
        return (Logger.Level)map.get(s.toUpperCase());
    }

    private void scanAppCodes() {
        this.classLoader().scan();
    }

    static App create(File appBase, ProjectLayout layout) {
        return new App(appBase, layout);
    }

    public static enum F {

        public static Osgl.Predicate<String> JAVA_SOURCE = S.F.endsWith((String)".java");
        public static Osgl.Predicate<String> JAR_FILE = S.F.endsWith((String)".jar");
        public static Osgl.Predicate<String> CONF_FILE = S.F.endsWith((String)".conf").or(new Osgl.Function[]{S.F.endsWith((String)".properties")});
        public static Osgl.Predicate<String> ROUTES_FILE = Osgl.F.eq((Object)"routes.conf");
    }
}

