/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.ProjectLayout;
import act.app.RuntimeDirs;
import java.io.File;
import org.osgl.util.E;
import org.osgl.util.IO;

class AppBuilder {
    private static final AppBuilder PLACE_HOLDER = new AppBuilder(){

        @Override
        public void build() {
        }
    };
    private final App app;
    private final ProjectLayout layout;
    private final File appBase;
    private File tgtLib;
    private File tgtAsset;
    private File tgtClasses;
    private File tgtConf;

    private AppBuilder() {
        this.app = null;
        this.layout = null;
        this.appBase = null;
    }

    private AppBuilder(App app) {
        this.app = app;
        this.layout = app.layout();
        this.appBase = app.base();
    }

    public void build() {
        this.prepareTargetDir();
        this.copyFiles();
    }

    private void prepareTargetDir() {
        File target = this.layout.target(this.appBase);
        this.verifyDir(target, "target", true);
        this.tgtClasses = this.verifyDir(new File(target, "/classes"), "/classes", true);
        this.tgtLib = this.verifyDir(new File(target, "/lib"), "/lib", true);
        this.tgtAsset = this.verifyDir(new File(target, "/asset"), "/asset", true);
        this.tgtConf = this.verifyDir(new File(this.tgtClasses, "/conf"), "/conf", true);
    }

    private void copyFiles() {
        this.copyLibs();
        this.copyAssets();
        this.copyResources();
        this.copyConf();
        this.copyRoutes();
    }

    void copyAssets() {
        File asset = this.layout.asset(this.appBase);
        if (null == asset || !asset.canRead()) {
            return;
        }
        this.verifyDir(asset, "asset", false);
        IO.copyDirectory((File)asset, (File)this.tgtAsset);
    }

    void copyResources() {
        File resource = this.layout.resource(this.appBase);
        if (null == resource || !resource.canRead()) {
            return;
        }
        this.verifyDir(resource, "resource", false);
        IO.copyDirectory((File)resource, (File)this.tgtClasses);
    }

    void copyResources(File ... files) {
        File base = this.layout.resource(this.appBase);
        int baseLen = base.getAbsolutePath().length();
        for (File file : files) {
            String path = file.getAbsolutePath().substring(baseLen);
            File target = new File(this.tgtClasses, path);
            IO.copyDirectory((File)file, (File)target);
        }
    }

    void removeResources(File ... files) {
        File base = this.layout.resource(this.appBase);
        int baseLen = base.getAbsolutePath().length();
        for (File file : files) {
            String path = file.getAbsolutePath().substring(baseLen);
            File target = new File(this.tgtClasses, path);
            target.delete();
        }
    }

    void copyRoutes() {
        File routes = this.layout.routeTable(this.appBase);
        if (null == routes || !routes.canRead()) {
            return;
        }
        if (routes.exists() && routes.canRead()) {
            IO.copyDirectory((File)routes, (File)RuntimeDirs.routes(this.app));
        }
    }

    void copyConf() {
        File conf = this.layout.conf(this.appBase);
        if (null == conf || !conf.canRead()) {
            return;
        }
        if (conf.isDirectory()) {
            IO.copyDirectory((File)conf, (File)this.tgtConf);
        } else {
            IO.copyDirectory((File)conf, (File)new File(this.tgtConf, conf.getName()));
        }
    }

    void copyLibs() {
        File lib = this.layout.lib(this.appBase);
        if (null == lib || !lib.exists()) {
            return;
        }
        this.verifyDir(lib, "lib", false);
        IO.copyDirectory((File)lib, (File)this.tgtLib);
    }

    private File verifyDir(File dir, String label, boolean create) {
        if (create && !dir.exists()) {
            E.unexpectedIf((!dir.mkdirs() ? 1 : 0) != 0, (String)"Cannot create %s dir %s for %s", (Object[])new Object[]{dir, label, this.app});
            return dir;
        }
        E.unexpectedIf((!dir.isDirectory() ? 1 : 0) != 0, (String)"%s %s is not a directory", (Object[])new Object[]{label, dir});
        E.unexpectedIf((!dir.canRead() ? 1 : 0) != 0, (String)"Cannot read %s dir %s", (Object[])new Object[]{label, dir});
        E.unexpectedIf((!dir.canWrite() ? 1 : 0) != 0, (String)"Cannot write %s dir %s", (Object[])new Object[]{label, dir});
        return dir;
    }

    public static AppBuilder build(App app) {
        AppBuilder builder = PLACE_HOLDER;
        if (Act.mode() == Act.Mode.DEV) {
            builder = new AppBuilder(app);
        }
        builder.build();
        return builder;
    }
}

