/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppScanner;
import act.util.DestroyableBase;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Osgl;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;

public class AppManager
extends DestroyableBase {
    private static Logger logger = LogManager.get(AppManager.class);
    private Map<Integer, App> byPort = C.newMap((Object[])new Object[0]);

    private AppManager() {
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.byPort.values(), ApplicationScoped.class);
        this.byPort = null;
    }

    public AppManager scan() {
        Act.mode().appScanner().scan(null, (Osgl.Func1<App, ?>)_F.loadApp(this));
        return this;
    }

    public AppManager loadSingleApp(String name) {
        AppScanner.SINGLE_APP_SCANNER.scan(name, (Osgl.Func1<App, ?>)_F.loadApp(this));
        return this;
    }

    public void deploy(App app) {
        this.load(app);
        this.refresh(app);
    }

    public void refresh() {
        Iterator<App> itr = this.appIterator();
        while (itr.hasNext()) {
            this.refresh(itr.next());
        }
    }

    public void refresh(App app) {
        app.refresh();
    }

    public void load(App app) {
        app.build();
        app.refresh();
        int port = app.config().httpPort();
        E.invalidConfigurationIf((port < 0 ? 1 : 0) != 0, (String)"Invalid http.port configuration: %s", (Object[])new Object[]{port});
        this.loadIntoPortMap(port, app);
        app.hook();
    }

    public boolean unload(App app) {
        boolean b = this.unloadApp(app, this.byPort);
        if (this.byPort.isEmpty()) {
            Act.shutdown();
        }
        return b;
    }

    private boolean unloadApp(App app, Map<?, App> map) {
        for (Map.Entry<?, App> entry : map.entrySet()) {
            if (app != entry.getValue()) continue;
            app.destroy();
            map.remove(entry.getKey());
            return true;
        }
        return false;
    }

    private void loadIntoPortMap(int port, App app) {
        App app0 = this.byPort.get(port);
        if (null != app0) {
            E.invalidConfigurationIf((!app.equals(app0) ? 1 : 0) != 0, (String)"Another application has already been deployed using port %s", (Object[])new Object[]{port});
        } else {
            this.byPort.put(port, app);
        }
    }

    private Iterator<App> appIterator() {
        final Iterator<App> itrByPort = this.byPort.values().iterator();
        return new Iterator<App>(){
            boolean byPortFinished;
            {
                this.byPortFinished = !itrByPort.hasNext();
            }

            @Override
            public boolean hasNext() {
                if (!this.byPortFinished) {
                    this.byPortFinished = !itrByPort.hasNext();
                }
                return !this.byPortFinished;
            }

            @Override
            public App next() {
                return this.byPortFinished ? null : (App)itrByPort.next();
            }

            @Override
            public void remove() {
                E.unsupport();
            }
        };
    }

    public static AppManager create() {
        return new AppManager();
    }

    private static enum _F {


        static final Osgl.F1<App, ?> loadApp(final AppManager mgr) {
            return new Osgl.Visitor<App>(){

                public void visit(App app) throws Osgl.Break {
                    try {
                        mgr.load(app);
                    }
                    catch (RuntimeException e) {
                        Act.shutdownApp(app);
                        throw e;
                    }
                }
            };
        }
    }
}

