/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.AppThreadFactory;
import act.app.event.AppEventId;
import act.cli.CliSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.exception.ConfigurationException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;

@ApplicationScoped
public class CliServer
extends AppServiceBase<CliServer>
implements Runnable {
    private static final Logger logger = LogManager.get(CliServer.class);
    private ScheduledThreadPoolExecutor executor;
    private AtomicBoolean running = new AtomicBoolean();
    private ConcurrentMap<String, CliSession> sessions = new ConcurrentHashMap<String, CliSession>();
    private int port;
    private ServerSocket serverSocket;
    private Thread monitorThread;

    @Inject
    CliServer(App app) {
        super(app);
        this.port = app.config().cliPort();
        this.initExecutor(app);
        this.start();
    }

    @Override
    protected void releaseResources() {
        this.stop();
        this.executor.shutdown();
        Destroyable.Util.destroyAll(this.sessions.values(), ApplicationScoped.class);
        this.sessions.clear();
    }

    public void remove(CliSession session) {
        this.sessions.remove(session.id());
    }

    @Override
    public void run() {
        while (this.running()) {
            try {
                Socket socket = this.serverSocket.accept();
                CliSession session = new CliSession(socket, this);
                this.sessions.put(session.id(), session);
                this.executor.submit(session);
            }
            catch (Exception e) {
                if (this.isDestroyed()) {
                    return;
                }
                logger.error((Throwable)e, "Error processing CLI session");
                this.stop();
                return;
            }
        }
    }

    void stop() {
        if (!this.running()) {
            return;
        }
        this.running.set(false);
        if (null != this.monitorThread) {
            this.monitorThread.interrupt();
            this.monitorThread = null;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            logger.warn((Throwable)e, "error closing server socket");
        }
        finally {
            this.serverSocket = null;
        }
    }

    void start() {
        if (this.running()) {
            return;
        }
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.running.set(true);
            this.executor.submit(this);
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    CliServer.this.monitorThread = Thread.currentThread();
                    int expiration = CliServer.this.app().config().cliSessionExpiration();
                    while (CliServer.this.running()) {
                        C.List toBeRemoved = C.newList();
                        for (CliSession session : CliServer.this.sessions.values()) {
                            if (!session.expired(expiration)) continue;
                            toBeRemoved.add(session);
                        }
                        for (CliSession session : toBeRemoved) {
                            session.stop("your session is timeout");
                            CliServer.this.sessions.remove(session.id());
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        CliServer.this.app().checkUpdates(false);
                    }
                }
            });
            this.app().jobManager().on(AppEventId.ACT_START, new Runnable(){

                @Override
                public void run() {
                    Act.LOGGER.info("CLI server started on port: %s", new Object[]{CliServer.this.port});
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e, "Cannot start CLI server on port: %s", new Object[]{this.port});
        }
    }

    boolean running() {
        return this.running.get();
    }

    private void initExecutor(App app) {
        int poolSize = app.config().maxCliSession() + 2;
        this.executor = new ScheduledThreadPoolExecutor(poolSize, new AppThreadFactory("cli", true), new ThreadPoolExecutor.AbortPolicy());
    }
}

