/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.app.ActAppException;
import act.app.SourceInfo;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.osgl.util.IO;
import org.osgl.util.S;

public class CompilationException
extends ActAppException
implements SourceInfo {
    private String problem;
    private File source;
    private Integer line;
    private Integer start;
    private Integer end;

    public CompilationException(String problem) {
        super(problem);
        this.problem = problem;
    }

    public CompilationException(File source, String problem, int line, int start, int end) {
        super(problem);
        this.problem = problem;
        this.line = line;
        this.source = source;
        this.start = start;
        this.end = end;
    }

    @Override
    public String getErrorTitle() {
        return "Compilation error";
    }

    @Override
    public String getErrorDescription() {
        return S.fmt((String)"The file <strong>%s</strong> could not be compiled.\nError raised is : <strong>%s</strong>", (Object[])new Object[]{this.isSourceAvailable() ? this.source.getPath() : "", this.problem.replace("<", "&lt;")});
    }

    @Override
    public String fileName() {
        return this.source.getName();
    }

    @Override
    public List<String> lines() {
        String sourceCode = IO.readContentAsString((File)this.source);
        if (this.start != -1 && this.end != -1) {
            sourceCode = this.start.equals(this.end) ? sourceCode.substring(0, this.start + 1) + "\u2193" + sourceCode.substring(this.end + 1) : sourceCode.substring(0, this.start) + "\u0000" + sourceCode.substring(this.start, this.end + 1) + "\u0001" + sourceCode.substring(this.end + 1);
        }
        return Arrays.asList(sourceCode.split("\n"));
    }

    @Override
    public Integer lineNumber() {
        return this.line;
    }

    @Override
    public boolean isSourceAvailable() {
        return this.source != null && this.line != null;
    }

    public Integer getSourceStart() {
        return this.start;
    }

    public Integer getSourceEnd() {
        return this.end;
    }
}

