/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.app.App;
import act.app.Daemon;
import act.cli.CliContext;
import act.cli.Command;
import act.cli.Required;
import act.data.JodaDateTimeCodec;
import act.util.PropertySpec;
import java.util.Map;
import org.joda.time.DateTime;
import org.osgl.inject.annotation.Provided;
import org.osgl.util.E;

public class DaemonAdmin {
    @Command(name="act.daemon.list", help="List app daemons")
    @PropertySpec(value={"id,state"})
    public Iterable<Daemon> list() {
        return App.instance().registeredDaemons();
    }

    @Command(name="act.daemon.start", help="Start app daemon")
    public void start(@Required(value="specify daemon id") String id, CliContext context) {
        Daemon daemon = DaemonAdmin.get(id, context);
        daemon.start();
        DaemonAdmin.report(daemon, context);
    }

    @Command(name="act.daemon.stop", help="Stop app daemon")
    public void stop(@Required(value="specify daemon id") String id, CliContext context) {
        Daemon daemon = DaemonAdmin.get(id, context);
        daemon.stop();
        DaemonAdmin.report(daemon, context);
    }

    @Command(name="act.daemon.restart", help="Re-Start app daemon")
    public void restart(@Required(value="specify daemon id") String id, CliContext context) {
        Daemon daemon = DaemonAdmin.get(id, context);
        daemon.restart();
        DaemonAdmin.report(daemon, context);
    }

    @Command(name="act.daemon.status", help="Report app daemon status")
    public void status(@Required(value="specify daemon id") String id, CliContext context, @Provided JodaDateTimeCodec fmt) {
        Map<String, Object> attributes;
        Daemon daemon = DaemonAdmin.get(id, context);
        Daemon.State state = daemon.state();
        DateTime ts = daemon.timestamp();
        Exception lastError = daemon.lastError();
        context.println("Daemon[%s]: %s at %s", new Object[]{id, state, fmt.toString(ts)});
        if (null != lastError) {
            DateTime errTs = daemon.errorTimestamp();
            if (null != errTs) {
                context.println("Last error: %s at %s", E.stackTrace((Throwable)lastError), fmt.toString(errTs));
            } else {
                context.println("Last error: %s", E.stackTrace((Throwable)lastError));
            }
        }
        if (!(attributes = daemon.getAttributes()).isEmpty()) {
            context.println("Attributes: %s", attributes);
        }
    }

    private static Daemon get(String id, CliContext context) {
        Daemon daemon = App.instance().registeredDaemon(id);
        if (null == daemon) {
            context.println("Unknown daemon: %s", id);
            return null;
        }
        return daemon;
    }

    private static void report(Daemon daemon, CliContext context) {
        context.println("Daemon[%s]: %s", new Object[]{daemon.id(), daemon.state()});
    }
}

