/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.DaoLocator;
import act.app.event.AppEventId;
import act.conf.AppConfig;
import act.db.DB;
import act.db.Dao;
import act.db.DbManager;
import act.db.DbPlugin;
import act.db.DbService;
import act.db.util.SequenceNumberGenerator;
import act.db.util._SequenceNumberGenerator;
import act.event.AppEventListenerBase;
import act.util.ClassNode;
import act.util.General;
import java.lang.annotation.Annotation;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.ConfigurationException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.rythmengine.utils.S;

@ApplicationScoped
public class DbServiceManager
extends AppServiceBase<DbServiceManager>
implements DaoLocator {
    private static Logger logger = LogManager.get(DbServiceManager.class);
    public static final String DEFAULT = "default";
    private Map<String, DbService> serviceMap = C.newMap((Object[])new Object[0]);
    private Map<Class<?>, Dao> modelDaoMap = C.newMap((Object[])new Object[0]);

    @Inject
    public DbServiceManager(final App app) {
        super(app);
        this.initServices(app.config());
        this.configureSequenceGenerator(app);
        app.eventBus().bind(AppEventId.SINGLETON_PROVISIONED, new AppEventListenerBase(){

            @Override
            public void on(EventObject event) throws Exception {
                ClassNode node = app.classLoader().classInfoRepository().node(Dao.class.getName());
                node.visitPublicNotAbstractTreeNodes((Osgl.Function<ClassNode, ?>)new Osgl.Visitor<ClassNode>(){

                    private boolean isGeneral(Class c) {
                        Annotation[] aa;
                        for (Annotation a : aa = c.getDeclaredAnnotations()) {
                            if (!(a instanceof General)) continue;
                            return true;
                        }
                        return false;
                    }

                    public void visit(ClassNode classNode) throws Osgl.Break {
                        Class daoType = $.classForName((String)classNode.name(), (ClassLoader)app.classLoader());
                        if (this.isGeneral(daoType)) {
                            return;
                        }
                        try {
                            Dao dao = (Dao)$.cast(app.getInstance(daoType));
                            Class modelType = dao.modelType();
                            DB db = modelType.getAnnotation(DB.class);
                            String svcId = null == db ? DbServiceManager.DEFAULT : db.value();
                            Object dbService = DbServiceManager.this.dbService(svcId);
                            E.invalidConfigurationIf((null == dbService ? 1 : 0) != 0, (String)"cannot find db service by id: %s", (Object[])new Object[]{svcId});
                            dao = ((DbService)dbService).newDaoInstance(daoType);
                            DbServiceManager.this.modelDaoMap.put(modelType, dao);
                        }
                        catch (Exception e) {
                            logger.warn((Throwable)e, "error loading DAO: %s", new Object[]{daoType});
                        }
                    }
                });
            }
        });
    }

    private void configureSequenceGenerator(final App app) {
        app.jobManager().on(AppEventId.DEPENDENCY_INJECTOR_PROVISIONED, new Runnable(){

            @Override
            public void run() {
                _SequenceNumberGenerator seqGen = app.config().sequenceNumberGenerator();
                seqGen.configure(app.config(), DbServiceManager.this);
                SequenceNumberGenerator.registerImpl(seqGen);
            }
        });
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.serviceMap.values(), ApplicationScoped.class);
        this.serviceMap.clear();
        Destroyable.Util.tryDestroyAll(this.modelDaoMap.values(), ApplicationScoped.class);
        this.modelDaoMap.clear();
    }

    @Override
    public Dao dao(Class<?> modelClass) {
        Dao dao = this.modelDaoMap.get(modelClass);
        if (null == dao) {
            Annotation[] aa;
            String svcId = DEFAULT;
            for (Annotation a : aa = modelClass.getDeclaredAnnotations()) {
                if (!(a instanceof DB)) continue;
                svcId = ((DB)a).value();
            }
            Object dbService = this.dbService(svcId);
            dao = ((DbService)dbService).defaultDao(modelClass);
            this.modelDaoMap.put(modelClass, dao);
        }
        return dao;
    }

    public <T extends DbService> T dbService(String id) {
        return (T)this.serviceMap.get(id);
    }

    public Iterable<DbService> registeredServices() {
        return this.serviceMap.values();
    }

    private void initServices(AppConfig config) {
        DbManager dbManager = Act.dbManager();
        if (!dbManager.hasPlugin()) {
            logger.warn("DB service not initialized: No DB plugin found");
            return;
        }
        DbPlugin db = dbManager.theSolePlugin();
        Map dbConf = config.subSet("db.");
        if (dbConf.isEmpty()) {
            if (null == db) {
                logger.warn("DB service not intialized: need to specify default db service implementation");
                return;
            }
            logger.warn("DB configuration not found. Will try to init default service with the sole db plugin: %s", new Object[]{db});
            DbService svc = db.initDbService(DEFAULT, this.app(), new HashMap<String, Object>());
            this.serviceMap.put(DEFAULT, svc);
            return;
        }
        String firstInstance = null;
        if (dbConf.containsKey("db.instances")) {
            String[] sa;
            String instances = dbConf.get("db.instances").toString();
            for (String dbId : sa = instances.split("[,\\s;:]+")) {
                this.initService(dbId, dbConf);
            }
            firstInstance = sa[0];
        }
        if (this.serviceMap.containsKey(DEFAULT)) {
            return;
        }
        String dbId = null;
        if (dbConf.containsKey("db.default.impl")) {
            dbId = DEFAULT;
        } else if (dbConf.containsKey("db.impl")) {
            dbId = "";
        }
        if (null != dbId) {
            this.initService(dbId, dbConf);
        } else if (this.serviceMap.size() == 1) {
            DbService svc = this.serviceMap.values().iterator().next();
            this.serviceMap.put(DEFAULT, svc);
            logger.warn("db service configuration not found. Use the sole one db service[%s] as default service", new Object[]{svc.id()});
        } else if (this.serviceMap.isEmpty()) {
            if (null == db) {
                logger.warn("DB service not initialized: need to specify default db service implementation");
            } else {
                logger.warn("DB configuration not found. Will try to init default service with the sole db plugin: %s", new Object[]{db});
                C.Map svcConf = C.newMap((Object[])new Object[0]);
                String prefix = "db.";
                for (String key : dbConf.keySet()) {
                    if (!key.startsWith(prefix)) continue;
                    Object o = dbConf.get(key);
                    svcConf.put(key.substring(prefix.length()), o);
                }
                DbService svc = db.initDbService(DEFAULT, this.app(), (Map<String, Object>)svcConf);
                this.serviceMap.put(DEFAULT, svc);
            }
        } else {
            logger.warn("Default service not specified. Use the first db instance as default service: %s", new Object[]{firstInstance});
            this.serviceMap.put(DEFAULT, this.serviceMap.get(firstInstance));
        }
    }

    private void initService(String dbId, Map<String, Object> conf) {
        String svcId;
        C.Map svcConf = C.newMap((Object[])new Object[0]);
        String prefix = "db." + (S.empty((String)dbId) ? "" : dbId + ".");
        for (String key : conf.keySet()) {
            if (!key.startsWith(prefix)) continue;
            Object o = conf.get(key);
            svcConf.put(key.substring(prefix.length()), o);
        }
        Object impl = svcConf.remove("impl");
        String string = svcId = S.empty((String)dbId) ? DEFAULT : dbId;
        if (null == impl) {
            throw new ConfigurationException("Cannot init db service[%s]: implementation not specified", new Object[]{svcId});
        }
        DbPlugin plugin = Act.dbManager().plugin(impl.toString());
        if (null == plugin) {
            throw new ConfigurationException("Cannot init db service[%s]: implementation not found", new Object[]{svcId});
        }
        DbService svc = plugin.initDbService(dbId, this.app(), (Map<String, Object>)svcConf);
        this.serviceMap.put(svcId, svc);
        logger.info("db service[%s] initialized", new Object[]{svcId});
    }
}

