/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.E;

public interface ProjectLayout {
    public static final String PROJ_LAYOUT_FILE = "proj.layout";

    public File source(File var1);

    public File testSource(File var1);

    public File resource(File var1);

    public File testResource(File var1);

    public File lib(File var1);

    public File testLib(File var1);

    public File asset(File var1);

    public File target(File var1);

    public File routeTable(File var1);

    public File conf(File var1);

    public static enum F {

        public static Osgl.F2<File, ProjectLayout, File> SRC = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.source(base);
            }
        };
        public static Osgl.F2<File, ProjectLayout, File> RSRC = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.resource(base);
            }
        };
        public static Osgl.F2<File, ProjectLayout, File> LIB = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.lib(base);
            }
        };
        public static Osgl.F2<File, ProjectLayout, File> TST_SRC = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.testSource(base);
            }
        };
        public static Osgl.F2<File, ProjectLayout, File> TST_RSRC = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.testResource(base);
            }
        };
        public static Osgl.F2<File, ProjectLayout, File> TST_LIB = new Osgl.F2<File, ProjectLayout, File>(){

            public File apply(File base, ProjectLayout layout) throws NotAppliedException, Osgl.Break {
                return layout.testLib(base);
            }
        };
    }

    public static enum Utils {


        public static File file(File parent, String path) {
            try {
                return new File(parent, path).getCanonicalFile();
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
    }

    public static class CustomizedProjectLayout
    implements ProjectLayout {
        private String source;
        private String testSource;
        private String lib;
        private String testLib;
        private String routeTable;
        private String conf;
        private String target;
        private String asset;
        private String resource;
        private String testResource;

        public CustomizedProjectLayout(String src, String testSource, String resource, String testResource, String lib, String testLib, String asset, String tgt, String routeTable, String conf) {
            this.source = src;
            this.testSource = testSource;
            this.resource = resource;
            this.testResource = testResource;
            this.lib = lib;
            this.testLib = testLib;
            this.asset = asset;
            this.target = tgt;
            this.routeTable = routeTable;
            this.conf = conf;
        }

        @Override
        public File source(File appBase) {
            return Utils.file(appBase, this.source);
        }

        @Override
        public File testSource(File appBase) {
            return Utils.file(appBase, this.testSource);
        }

        @Override
        public File lib(File appBase) {
            return Utils.file(appBase, this.lib);
        }

        @Override
        public File testLib(File appBase) {
            return Utils.file(appBase, this.testLib);
        }

        @Override
        public File routeTable(File appBase) {
            return Utils.file(appBase, this.routeTable);
        }

        @Override
        public File resource(File appBase) {
            return Utils.file(appBase, this.resource);
        }

        @Override
        public File testResource(File appBase) {
            return Utils.file(appBase, this.testResource);
        }

        @Override
        public File asset(File appBase) {
            return Utils.file(appBase, this.asset);
        }

        @Override
        public File conf(File appBase) {
            return Utils.file(appBase, this.conf);
        }

        @Override
        public File target(File appBase) {
            return Utils.file(appBase, this.target);
        }
    }

    public static enum util {


        public static boolean probeAppBase(File dir, ProjectLayout layout) {
            File conf = layout.conf(dir);
            if (null != conf && conf.canRead() && conf.isFile()) {
                return true;
            }
            File src = layout.source(dir);
            return null != src && src.canRead() && src.isDirectory();
        }

        public static ProjectLayout build(Properties p) {
            String source = util._get("source", p);
            String testSource = util._get("testSource", p);
            String lib = util._get("lib", p);
            String testLib = util._get("testLib", p);
            String resource = util._get("resource", p);
            String testResource = util._get("testResource", p);
            String asset = util._get("asset", p);
            String routes = util._get("routes", p);
            String conf = util._get("conf", p);
            String target = util._get("target", p);
            return new CustomizedProjectLayout(source, testSource, resource, testResource, lib, testLib, asset, target, routes, conf);
        }

        private static String _get(String key, Properties p) {
            String s = p.getProperty(key);
            E.invalidConfigurationIf((null == s ? 1 : 0) != 0, (String)"cannot findBy '%s' setting in project layout properties", (Object[])new Object[]{key});
            return s;
        }
    }

    public static enum PredefinedLayout implements ProjectLayout
    {
        MAVEN{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "src/main/java");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "src/test/java");
            }

            @Override
            public File resource(File appBase) {
                String resources = Act.isDev() ? "src/main/resources" : "classes";
                return Utils.file(appBase, resources);
            }

            @Override
            public File testResource(File appBase) {
                String resources = Act.isDev() ? "src/test/resources" : "test-classes";
                return Utils.file(appBase, resources);
            }

            @Override
            public File lib(File appBase) {
                String lib = Act.isDev() ? "src/main/lib" : "lib";
                return Utils.file(appBase, lib);
            }

            @Override
            public File testLib(File appBase) {
                String lib = Act.isDev() ? "src/test/lib" : "test-lib";
                return Utils.file(appBase, lib);
            }

            @Override
            public File asset(File appBase) {
                String asset = Act.isDev() ? "src/main/asset" : "asset";
                return Utils.file(appBase, asset);
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "target");
            }
        }
        ,
        PKG{

            @Override
            public File source(File appBase) {
                return null;
            }

            @Override
            public File testSource(File appBase) {
                return null;
            }

            @Override
            public File testResource(File appBase) {
                return null;
            }

            @Override
            public File testLib(File appBase) {
                return null;
            }

            @Override
            public File resource(File appBase) {
                return Utils.file(appBase, "classes");
            }

            @Override
            public File lib(File appBase) {
                return Utils.file(appBase, "lib");
            }

            @Override
            public File asset(File appBase) {
                return Utils.file(appBase, "asset");
            }

            @Override
            public File target(File appBase) {
                return appBase;
            }
        }
        ,
        PLAY{

            @Override
            public File source(File appBase) {
                return Utils.file(appBase, "app");
            }

            @Override
            public File testSource(File appBase) {
                return Utils.file(appBase, "test");
            }

            @Override
            public File resource(File appBase) {
                return Utils.file(appBase, "conf");
            }

            @Override
            public File testResource(File appBase) {
                return this.resource(appBase);
            }

            @Override
            public File lib(File appBase) {
                return Utils.file(appBase, "lib");
            }

            @Override
            public File testLib(File appBase) {
                return this.lib(appBase);
            }

            @Override
            public File asset(File appBase) {
                return Utils.file(appBase, "public");
            }

            @Override
            public File target(File appBase) {
                return Utils.file(appBase, "tmp");
            }
        };


        @Override
        public File conf(File appBase) {
            File confBase = Act.isDev() ? this.resource(appBase) : new File(appBase, "/classes");
            File file = new File(confBase, "/conf");
            return file.exists() ? file : confBase;
        }

        @Override
        public File routeTable(File appBase) {
            return Utils.file(this.resource(appBase), "routes.conf");
        }

        public static ProjectLayout valueOfIgnoreCase(String s) {
            s = s.trim().toUpperCase();
            if (MAVEN.name().equals(s)) {
                return MAVEN;
            }
            if (PLAY.name().equals(s)) {
                return PLAY;
            }
            return null;
        }
    }
}

