/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.event.AppEventId;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;

public class SingletonRegistry
extends AppServiceBase<SingletonRegistry> {
    private ConcurrentMap<Class<?>, Object> registry = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, Class<?>> preRegistry = new ConcurrentHashMap();
    private boolean batchRegistered = false;

    SingletonRegistry(App app) {
        super(app, false);
    }

    synchronized void register(Class<?> singletonClass) {
        if (!this.batchRegistered) {
            if (this.preRegistry.isEmpty()) {
                this.app().jobManager().on(AppEventId.DEPENDENCY_INJECTOR_PROVISIONED, "register-singleton-instances", new Runnable(){

                    @Override
                    public void run() {
                        SingletonRegistry.this.doRegister();
                    }
                }, true);
            }
            this.preRegistry.put(singletonClass, singletonClass);
        } else {
            this.register(singletonClass, this.app().getInstance(singletonClass));
        }
    }

    public void register(Class singletonClass, Object singleton) {
        this.registry.put(singletonClass, singleton);
    }

    synchronized <T> T get(Class<T> singletonClass) {
        return (T)$.cast(this.registry.get(singletonClass));
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.registry.values(), ApplicationScoped.class);
        this.registry.clear();
    }

    private synchronized void doRegister() {
        this.batchRegistered = true;
        for (Class c : this.preRegistry.keySet()) {
            this.registry.put(c, this.app().getInstance(c));
        }
        this.preRegistry.clear();
    }
}

