/*
 * Decompiled with CFR 0.152.
 */
package act.app.conf;

import act.app.App;
import act.app.AppByteCodeScanner;
import act.app.conf.AutoConfig;
import act.app.data.StringValueResolverManager;
import act.app.event.AppEventId;
import act.conf.AppConfig;
import act.event.AppEventListenerBase;
import act.util.AnnotatedTypeFinder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.AnnotationAware;
import org.osgl.util.Const;
import org.osgl.util.E;
import org.osgl.util.StringValueResolver;

public class AutoConfigPlugin
extends AnnotatedTypeFinder {
    private static final Logger logger = LogManager.get(AutoConfigPlugin.class);
    private static Field modifiersField;

    public AutoConfigPlugin() {
        super(true, false, AutoConfig.class, (Osgl.Func2<App, String, Map<Class<? extends AppByteCodeScanner>, Set<String>>>)new Osgl.F2<App, String, Map<Class<? extends AppByteCodeScanner>, Set<String>>>(){

            public Map<Class<? extends AppByteCodeScanner>, Set<String>> apply(final App app, final String className) throws NotAppliedException, Osgl.Break {
                app.eventBus().bind(AppEventId.PRE_START, new AppEventListenerBase(){

                    @Override
                    public void on(EventObject event) throws Exception {
                        Class autoConfigClass = $.classForName((String)className, (ClassLoader)app.classLoader());
                        new AutoConfigLoader(app, autoConfigClass).load();
                    }
                });
                return null;
            }
        });
    }

    private static void allowChangeFinalField() {
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    private static void resetFinalFieldUpdate() {
        try {
            modifiersField.setAccessible(false);
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
    }

    public static void loadPluginAutoConfig(Class<?> autoConfigClass, App app) {
        new AutoConfigLoader(app, autoConfigClass).load();
    }

    private static class AutoConfigLoader {
        private AppConfig conf;
        private Class<?> autoConfigClass;
        private String ns;
        private StringValueResolverManager resolverManager;
        private Injector injector;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AutoConfigLoader(App app, Class<?> autoConfigClass) {
            this.conf = app.config();
            this.autoConfigClass = autoConfigClass;
            this.ns = autoConfigClass.getAnnotation(AutoConfig.class).value();
            this.resolverManager = app.resolverManager();
            this.injector = app.injector();
            Class<AutoConfigLoader> clazz = AutoConfigLoader.class;
            synchronized (AutoConfigLoader.class) {
                AutoConfigPlugin.allowChangeFinalField();
                app.jobManager().on(AppEventId.START, new Runnable(){

                    @Override
                    public void run() {
                        AutoConfigPlugin.resetFinalFieldUpdate();
                    }
                });
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private boolean turnOffFinal(Field field) {
            field.setAccessible(true);
            if (Modifier.isFinal(field.getModifiers())) {
                try {
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                catch (Exception e) {
                    throw E.unexpected((Throwable)e);
                }
                return true;
            }
            return false;
        }

        private void turnOnFinal(Field field) {
            try {
                modifiersField.setInt(field, field.getModifiers() | 0x10);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }

        void load() {
            this.loadClass(this.autoConfigClass, this.ns);
        }

        void loadClass(Class<?> c, String ns) {
            Field[] fa;
            Class<?>[] ca;
            for (Class<?> c0 : ca = c.getClasses()) {
                int mod = c0.getModifiers();
                if (!Modifier.isStatic(mod)) continue;
                this.loadClass(c0, ns + "." + c0.getSimpleName());
            }
            for (Field f2 : fa = c.getDeclaredFields()) {
                if (!Modifier.isStatic(f2.getModifiers())) continue;
                this.loadAutoConfig_(f2, ns);
            }
        }

        private void loadAutoConfig_(Field f2, String ns) {
            String key = ns + "." + f2.getName();
            Object val = this.conf.getIgnoreCase(key);
            if (null == val && null == (val = this.conf.getIgnoreCase(key = key.replace('_', '.')))) {
                return;
            }
            BeanSpec spec = BeanSpec.of((Field)f2, (Injector)this.injector);
            boolean isFinal = false;
            try {
                isFinal = this.turnOffFinal(f2);
                this.setField(f2, null, key, val, spec);
            }
            catch (Exception e) {
                throw E.invalidConfiguration((Throwable)e, (String)("Error get configuration " + key + ": " + e.getMessage()), (Object[])new Object[0]);
            }
            finally {
                if (isFinal) {
                    this.turnOnFinal(f2);
                }
            }
        }

        private void setField(Field f2, Object host, String key, Object val, BeanSpec spec) throws Exception {
            if (spec.isInstanceOf(Osgl.Val.class)) {
                Osgl.Val value = (Osgl.Val)$.cast((Object)f2.get(host));
                Field fVal = Osgl.Var.class.getDeclaredField("v");
                fVal.setAccessible(true);
                BeanSpec spec0 = BeanSpec.of((Type)((Type)spec.typeParams().get(0)), null, (Injector)this.injector);
                this.setField(fVal, value, key, val, spec0);
                fVal.setAccessible(false);
            } else if (spec.isInstanceOf(Const.class)) {
                Const value = (Const)$.cast((Object)f2.get(host));
                Field fConst = Const.class.getDeclaredField("v");
                fConst.setAccessible(true);
                BeanSpec spec0 = BeanSpec.of((Type)((Type)spec.typeParams().get(0)), null, (Injector)this.injector);
                this.setField(fConst, value, key, val, spec0);
                fConst.setAccessible(false);
            } else if (spec.isInstanceOf(Collection.class)) {
                BeanSpec spec0 = BeanSpec.of((Type)((Type)spec.typeParams().get(0)), null, (Injector)this.injector);
                StringValueResolver resolver = this.resolverManager.resolver(spec0.rawType(), (AnnotationAware)spec);
                if (null == resolver) {
                    logger.warn("Config[%s] field type[%s] not recognized", new Object[]{key, spec});
                } else {
                    String[] sa;
                    Collection col = (Collection)this.injector.get(spec.rawType());
                    for (String s : sa = val.toString().split(",")) {
                        col.add(resolver.resolve(s));
                    }
                    f2.set(host, col);
                }
            } else {
                StringValueResolver resolver = this.resolverManager.resolver(spec.rawType());
                if (null == resolver) {
                    logger.warn("Config[%s] field type[%s] not recognized", new Object[]{key, spec.rawType()});
                } else {
                    f2.set(host, resolver.resolve(val.toString()));
                }
            }
        }
    }
}

