/*
 * Decompiled with CFR 0.152.
 */
package act.app.data;

import act.app.App;
import act.app.AppServiceBase;
import act.conf.AppConfig;
import act.data.SObjectResolver;
import java.util.Map;
import org.osgl.$;
import org.osgl.storage.ISObject;
import org.osgl.util.AnnotationAware;
import org.osgl.util.C;
import org.osgl.util.StringValueResolver;

public class StringValueResolverManager
extends AppServiceBase<StringValueResolverManager> {
    private Map<Class, StringValueResolver> resolvers = C.newMap((Object[])new Object[0]);

    public StringValueResolverManager(App app) {
        super(app);
        this.registerPredefinedResolvers();
        this.registerBuiltInResolvers(app.config());
    }

    @Override
    protected void releaseResources() {
        this.resolvers.clear();
    }

    public <T> StringValueResolverManager register(Class<T> targetType, StringValueResolver<T> resolver) {
        this.resolvers.put(targetType, resolver);
        return this;
    }

    public Object resolve(String strVal, Class<?> targetType) {
        StringValueResolver<?> r = this.resolver(targetType);
        return null != r ? r.resolve(strVal) : null;
    }

    public <T> StringValueResolver<T> resolver(Class<T> targetType) {
        StringValueResolver r = this.resolvers.get(targetType);
        final Class clazz = (Class)$.cast(targetType);
        if (null == r && Enum.class.isAssignableFrom(targetType)) {
            r = this.app().config().enumResolvingCaseSensitive() ? new StringValueResolver<T>(targetType){

                public T resolve(String value) {
                    return Enum.valueOf(clazz, value);
                }
            } : new StringValueResolver<T>(targetType){

                public T resolve(String value) {
                    return $.asEnum((Class)clazz, (String)value);
                }
            };
            this.resolvers.put(targetType, r);
        }
        return r;
    }

    public <T> StringValueResolver<T> resolver(Class<T> targetType, AnnotationAware annotationAware) {
        StringValueResolver resolver = this.resolver(targetType);
        if (null != resolver) {
            resolver = resolver.amended(annotationAware);
        }
        return resolver;
    }

    private void registerPredefinedResolvers() {
        this.resolvers.putAll(StringValueResolver.predefined());
    }

    private void registerBuiltInResolvers(AppConfig config) {
        this.put(ISObject.class, SObjectResolver.INSTANCE);
    }

    private void put(Class type, StringValueResolver resolver) {
        this.app().registerSingleton(resolver);
        this.resolvers.put(type, resolver);
    }
}

