/*
 * Decompiled with CFR 0.152.
 */
package act.app.util;

import act.conf.AppConfig;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import org.mindrot.jbcrypt.BCrypt;
import org.osgl.exception.UnexpectedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.Charsets;
import org.osgl.util.Crypto;
import org.osgl.util.Token;

public class AppCrypto {
    private static Logger logger = LogManager.get(AppCrypto.class);
    private byte[] secret;
    private SecureRandom secureRandom = new SecureRandom();

    public AppCrypto(AppConfig config) {
        this.secret = config.secret().getBytes(Charsets.UTF_8);
    }

    public String sign(String message) {
        return Crypto.sign((String)message, (byte[])this.secret);
    }

    public String passwordHash(char[] password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public String passwordHash(String password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public boolean verifyPassword(String password, String hash) {
        try {
            return BCrypt.checkpw(password, hash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyPassword(char[] password, String hash) {
        try {
            return BCrypt.checkpw(password, hash);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String encrypt(String message) {
        try {
            return Crypto.encryptAES((String)message, (byte[])this.secret);
        }
        catch (UnexpectedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                logger.error("Cannot encrypt/decrypt! Please download Java Crypto Extension pack from Oracle: http://www.oracle.com/technetwork/java/javase/tech/index-jsp-136007.html");
            }
            throw e;
        }
    }

    public String decrypt(String message) {
        try {
            return Crypto.decryptAES((String)message, (byte[])this.secret);
        }
        catch (UnexpectedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidKeyException) {
                logger.error("Cannot encrypt/decrypt! Please download Java Crypto Extension pack from Oracle: http://www.oracle.com/technetwork/java/javase/tech/index-jsp-136007.html");
            }
            throw e;
        }
    }

    public int generateRandomInt(int max) {
        return this.secureRandom.nextInt(max);
    }

    public int generateRandomInt() {
        return this.secureRandom.nextInt(Integer.MAX_VALUE);
    }

    public String generateToken(String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (String)id, (String[])payload);
    }

    public String generateToken(Token.Life expiration, String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (Token.Life)expiration, (String)id, (String[])payload);
    }

    public String generateToken(int seconds, String id, String ... payload) {
        return Token.generateToken((byte[])this.secret, (long)seconds, (String)id, (String[])payload);
    }

    public Token parseToken(String tokenString) {
        return Token.parseToken((byte[])this.secret, (String)tokenString);
    }
}

