/*
 * Decompiled with CFR 0.152.
 */
package act.boot.app;

import act.Act;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.conf.AppConfigKey;
import act.util.SysProps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.osgl.$;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;

public class RunApp {
    private static final Logger LOGGER = Act.LOGGER;

    public static void start() throws Exception {
        RunApp.start(null, null, "");
    }

    public static void start(Class<?> anyController) throws Exception {
        RunApp.start(null, null, anyController);
    }

    public static void start(String packageName) throws Exception {
        RunApp.start(null, null, packageName);
    }

    public static void start(String appName, String appVersion, Class<?> anyController) throws Exception {
        String pkg = anyController.getPackage().getName();
        RunApp.start(appName, appVersion, pkg);
    }

    public static void start(String appName, String appVersion, String packageName) throws Exception {
        long ts = $.ms();
        String profile = SysProps.get(AppConfigKey.PROFILE.key());
        profile = S.blank((String)profile) ? "" : "using profile[" + profile + "]";
        LOGGER.debug("run fullstack application with package[%s] %s", new Object[]{packageName, profile});
        String SCAN_PACKAGE = AppConfigKey.SCAN_PACKAGE.key();
        if (S.notBlank((String)packageName)) {
            System.setProperty(SCAN_PACKAGE, packageName);
        }
        FullStackAppBootstrapClassLoader classLoader = new FullStackAppBootstrapClassLoader(RunApp.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> actClass = classLoader.loadClass("act.Act");
        Method m = actClass.getDeclaredMethod("startApp", String.class, String.class);
        try {
            m.invoke(null, appName, appVersion);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw E.unexpected((Throwable)t, (String)"Unknown error captured starting the application", (Object[])new Object[0]);
        }
        LOGGER.info("it takes %sms to start the app\n", new Object[]{$.ms() - ts});
    }

    public static void main(String[] args) throws Exception {
        RunApp.start();
    }
}

