/*
 * Decompiled with CFR 0.152.
 */
package act.cli.bytecode;

import act.Act;
import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.Attribute;
import act.asm.FieldVisitor;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.cli.CliDispatcher;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommandParamMetaInfo;
import act.cli.meta.CommanderClassMetaInfo;
import act.cli.meta.CommanderClassMetaInfoManager;
import act.cli.meta.FieldOptionAnnoInfo;
import act.cli.meta.OptionAnnoInfoBase;
import act.cli.meta.ParamOptionAnnoInfo;
import act.cli.view.CliView;
import act.sys.meta.SessionVariableAnnoInfo;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.PropertySpec;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class CommanderByteCodeScanner
extends AppByteCodeScannerBase {
    private static final Logger logger = L.get(CommanderByteCodeScanner.class);
    private CliDispatcher dispatcher;
    private CommanderClassMetaInfo classInfo;
    private volatile CommanderClassMetaInfoManager classInfoBase;

    @Override
    protected void reset(String className) {
        this.classInfo = new CommanderClassMetaInfo();
    }

    @Override
    protected boolean shouldScan(String className) {
        return null != this.dispatcher;
    }

    @Override
    protected void onAppSet() {
        this.dispatcher = this.app().cliDispatcher();
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        this.classInfoBase().registerCommanderMetaInfo(this.classInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommanderClassMetaInfoManager classInfoBase() {
        if (null == this.classInfoBase) {
            CommanderByteCodeScanner commanderByteCodeScanner = this;
            synchronized (commanderByteCodeScanner) {
                if (null == this.classInfoBase) {
                    this.classInfoBase = this.app().classLoader().commanderClassMetaInfoManager();
                }
            }
        }
        return this.classInfoBase;
    }

    private static class OptionAnnotationVisitorBase
    extends AnnotationVisitor
    implements Opcodes {
        protected List<String> specs = C.newList();
        protected OptionAnnoInfoBase optionAnnoInfo;

        public OptionAnnotationVisitorBase(AnnotationVisitor av, boolean optional) {
            super(327680, av);
        }

        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av = super.visitArray(name);
            if (S.eq((String)"lead", (String)name)) {
                return new AnnotationVisitor(327680, av){

                    public void visit(String name, Object value) {
                        super.visit(name, value);
                        OptionAnnotationVisitorBase.this.specs.add((String)value);
                    }
                };
            }
            return av;
        }

        public void visit(String name, Object value) {
            super.visit(name, value);
            if (S.eq((String)"group", (String)name)) {
                this.optionAnnoInfo.group((String)value);
            } else if (S.eq((String)"defVal", (String)name)) {
                this.optionAnnoInfo.defVal((String)value);
            } else if (S.eq((String)"value", (String)name) || S.eq((String)"help", (String)name)) {
                this.optionAnnoInfo.help((String)value);
            }
        }

        public void visitEnd() {
            if (!this.specs.isEmpty()) {
                this.optionAnnoInfo.spec(this.specs.toArray(new String[this.specs.size()]));
            }
            this.visitEnd2();
            super.visitEnd();
        }

        protected void visitEnd2() {
        }
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            CommanderByteCodeScanner.this.classInfo.className(name);
            Type superType = Type.getObjectType((String)superName);
            CommanderByteCodeScanner.this.classInfo.superType(superType);
            if (_ByteCodeVisitor.isAbstract(access)) {
                CommanderByteCodeScanner.this.classInfo.setAbstract();
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fv = super.visitField(access, name, desc, signature, value);
            Type type = Type.getType((String)desc);
            return new CommanderFieldVisitor(fv, name, type);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!this.isEligibleMethod(access, name, desc)) {
                return mv;
            }
            return new CommandMethodVisitor(mv, access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            for (CommandMethodMetaInfo commandMethodMetaInfo : CommanderByteCodeScanner.this.classInfo.commandList()) {
                CommanderByteCodeScanner.this.dispatcher.registerCommandHandler(commandMethodMetaInfo.commandName(), commandMethodMetaInfo, CommanderByteCodeScanner.this.classInfo);
            }
            super.visitEnd();
        }

        private boolean isEligibleMethod(int access, String name, String desc) {
            return _ByteCodeVisitor.isPublic(access) && !_ByteCodeVisitor.isAbstract(access) && !_ByteCodeVisitor.isConstructor(name);
        }

        private class CommandMethodVisitor
        extends MethodVisitor
        implements Opcodes {
            private String methodName;
            private int access;
            private String desc;
            private String signature;
            private boolean requireScan;
            private CommandMethodMetaInfo methodInfo;
            private Map<Integer, ParamOptionAnnoInfo> optionAnnoInfoMap;
            private Map<Integer, String> cliSessionAttributeMap;
            private BitSet contextInfo;
            private boolean isStatic;
            private Map<Integer, Boolean> readFileContentFlags;
            private Set<Integer> skipNaming;
            private int paramIdShift;

            CommandMethodVisitor(MethodVisitor mv, int access, String methodName, String desc, String signature, String[] exceptions) {
                super(327680, mv);
                this.optionAnnoInfoMap = C.newMap((Object[])new Object[0]);
                this.cliSessionAttributeMap = C.newMap((Object[])new Object[0]);
                this.contextInfo = new BitSet();
                this.readFileContentFlags = C.newMap((Object[])new Object[0]);
                this.skipNaming = new HashSet<Integer>();
                this.paramIdShift = 0;
                this.access = access;
                this.methodName = methodName;
                this.desc = desc;
                this.signature = signature;
                this.isStatic = AsmTypes.isStatic(access);
                this.methodInfo = new CommandMethodMetaInfo(CommanderByteCodeScanner.this.classInfo);
                if (this.isStatic) {
                    this.methodInfo.invokeStaticMethod();
                } else {
                    this.methodInfo.invokeInstanceMethod();
                }
                this.methodInfo.methodName(methodName);
                this.methodInfo.returnType(Type.getReturnType((String)desc));
                Type[] argTypes = Type.getArgumentTypes((String)desc);
                for (int i = 0; i < argTypes.length; ++i) {
                    Type type = argTypes[i];
                    CommandParamMetaInfo param = new CommandParamMetaInfo().type(type);
                    this.methodInfo.addParam(param);
                }
            }

            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (!"this".equals(name)) {
                    int paramId = index;
                    if (null == this.methodInfo) {
                        this.methodInfo = new CommandMethodMetaInfo(CommanderByteCodeScanner.this.classInfo);
                    }
                    if (!this.isStatic) {
                        --paramId;
                    }
                    if ((paramId -= this.paramIdShift) < this.methodInfo.paramCount()) {
                        CommandParamMetaInfo param = this.methodInfo.param(paramId);
                        param.name(name);
                        if (Type.getType(Long.TYPE).equals((Object)param.type()) || Type.getType(Double.TYPE).equals((Object)param.type())) {
                            ++this.paramIdShift;
                        }
                    }
                }
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                Type type = Type.getType((String)desc);
                if ($.eq((Object)AsmTypes.COMMAND.asmType(), (Object)type)) {
                    this.markRequireScan();
                    return new AnnotationVisitor(327680, av){

                        public void visit(String name, Object value) {
                            super.visit(name, value);
                            if (S.eq((String)"value", (String)name) || S.eq((String)"name", (String)name)) {
                                String commandName = S.string((Object)value);
                                if (S.empty((String)commandName)) {
                                    throw E.unexpected((String)"command name cannot be empty", (Object[])new Object[0]);
                                }
                                CommandMethodVisitor.this.methodInfo.commandName(commandName);
                            } else if (S.eq((String)"help", (String)name)) {
                                CommandMethodVisitor.this.methodInfo.helpMsg(S.string((Object)value));
                            }
                        }

                        public void visitEnum(String name, String desc, String value) {
                            super.visitEnum(name, desc, value);
                            if ("mode".equals(name)) {
                                CommandMethodVisitor.this.methodInfo.mode(Act.Mode.valueOf(value));
                            }
                        }

                        public void visitEnd() {
                            if (S.blank((String)CommandMethodVisitor.this.methodInfo.commandName())) {
                                throw new IllegalArgumentException("command name not defined");
                            }
                            super.visitEnd();
                        }
                    };
                }
                if ($.eq((Object)AsmTypes.CSV_VIEW.asmType(), (Object)type)) {
                    this.methodInfo.view(CliView.CSV);
                    return super.visitAnnotation(desc, visible);
                }
                if ($.eq((Object)AsmTypes.TREE_VIEW.asmType(), (Object)type)) {
                    this.methodInfo.view(CliView.TREE);
                    return super.visitAnnotation(desc, visible);
                }
                if ($.eq((Object)AsmTypes.TABLE_VIEW.asmType(), (Object)type)) {
                    this.methodInfo.view(CliView.TABLE);
                    return super.visitAnnotation(desc, visible);
                }
                if ($.eq((Object)AsmTypes.JSON_VIEW.asmType(), (Object)type)) {
                    this.methodInfo.view(CliView.JSON);
                    return super.visitAnnotation(desc, visible);
                }
                if ($.eq((Object)AsmTypes.PROPERTY_SPEC.asmType(), (Object)type)) {
                    final PropertySpec.MetaInfo propSpec = new PropertySpec.MetaInfo();
                    this.methodInfo.propertySpec(propSpec);
                    return new AnnotationVisitor(327680, av){

                        public AnnotationVisitor visitArray(String name) {
                            AnnotationVisitor av0 = super.visitArray(name);
                            if (S.eq((String)"value", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        propSpec.onValue(S.string((Object)value));
                                    }
                                };
                            }
                            if (S.eq((String)"cli", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        propSpec.onCli(S.string((Object)value));
                                    }
                                };
                            }
                            if (S.eq((String)"http", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        propSpec.onHttp(S.string((Object)value));
                                    }
                                };
                            }
                            return av0;
                        }
                    };
                }
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(final int paramIndex, String desc, boolean visible) {
                boolean isRequired;
                AnnotationVisitor av = super.visitParameterAnnotation(paramIndex, desc, visible);
                Type type = Type.getType((String)desc);
                boolean isOptional = $.eq((Object)type, (Object)AsmTypes.OPTIONAL.asmType());
                boolean bl = isRequired = !isOptional && $.eq((Object)type, (Object)AsmTypes.REQUIRED.asmType());
                if (isOptional || isRequired) {
                    if (this.optionAnnoInfoMap.containsKey(paramIndex)) {
                        throw E.unexpected((String)"Option annotation already found on index %s", (Object[])new Object[]{paramIndex});
                    }
                    return new ParamOptionAnnotationVisitor(av, paramIndex, isOptional);
                }
                if ($.eq((Object)type, (Object)AsmTypes.CONTEXT.asmType())) {
                    this.contextInfo.set(paramIndex);
                    return av;
                }
                if ($.eq((Object)type, (Object)AsmTypes.READ_FILE_CONTENT.asmType())) {
                    this.readFileContentFlags.put(paramIndex, true);
                    return av;
                }
                if ($.eq((Object)type, (Object)AsmTypes.CLI_SESSION_ATTRIBUTE.asmType())) {
                    return new AnnotationVisitor(327680, av){
                        private String attributeKey;
                        {
                            super(x0, x1);
                            this.attributeKey = "";
                        }

                        public void visit(String name, Object value) {
                            if ("value".equals(name)) {
                                this.attributeKey = S.string((Object)value);
                            }
                        }

                        public void visitEnd() {
                            CommandMethodVisitor.this.cliSessionAttributeMap.put(paramIndex, this.attributeKey);
                            super.visitEnd();
                        }
                    };
                }
                if ("Ljavax/inject/Named;".equals(desc)) {
                    this.skipNaming.add(paramIndex);
                    return av;
                }
                return av;
            }

            public void visitEnd() {
                if (!this.requireScan()) {
                    super.visitEnd();
                    return;
                }
                CommanderByteCodeScanner.this.classInfo.addCommand(this.methodInfo);
                Type[] argTypes = Type.getArgumentTypes((String)this.desc);
                for (int i = 0; i < argTypes.length; ++i) {
                    ParamOptionAnnoInfo option;
                    CommandParamMetaInfo param = this.methodInfo.param(i);
                    if (this.contextInfo.get(i)) {
                        param.setContext();
                    }
                    if (null != (option = this.optionAnnoInfoMap.get(i))) {
                        param.optionInfo(option);
                        this.methodInfo.addLead(option.lead1());
                        this.methodInfo.addLead(option.lead2());
                    }
                    if (null != this.readFileContentFlags.get(i)) {
                        param.setReadFileContent();
                    }
                    if (this.skipNaming.contains(i)) continue;
                    String string = param.name();
                }
                super.visitEnd();
            }

            private void markRequireScan() {
                this.requireScan = true;
            }

            private boolean requireScan() {
                return this.requireScan;
            }

            private class ParamOptionAnnotationVisitor
            extends OptionAnnotationVisitorBase
            implements Opcodes {
                protected int index;

                public ParamOptionAnnotationVisitor(AnnotationVisitor av, int index, boolean optional) {
                    super(av, optional);
                    this.index = index;
                    this.optionAnnoInfo = new ParamOptionAnnoInfo(index, optional);
                }

                @Override
                public void visitEnd2() {
                    CommandMethodVisitor.this.optionAnnoInfoMap.put(this.index, (ParamOptionAnnoInfo)this.optionAnnoInfo);
                }
            }
        }

        private class CommanderFieldVisitor
        extends FieldVisitor
        implements Opcodes {
            private String fieldName;
            private boolean readFileContent;
            private Type type;

            public CommanderFieldVisitor(FieldVisitor fv, String fieldName, Type type) {
                super(327680, fv);
                this.fieldName = fieldName;
                this.type = type;
            }

            public void visitAttribute(Attribute attr) {
                super.visitAttribute(attr);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                Type type = Type.getType((String)desc);
                boolean isOptional = $.eq((Object)type, (Object)AsmTypes.OPTIONAL.asmType());
                boolean isRequired = !isOptional && $.eq((Object)type, (Object)AsmTypes.REQUIRED.asmType());
                boolean bl = this.readFileContent = !isOptional && !isRequired && $.eq((Object)type, (Object)AsmTypes.READ_FILE_CONTENT.asmType());
                if (isOptional || isRequired) {
                    return new FieldOptionAnnotationVisitor(av, isOptional, this.fieldName, this.type);
                }
                if ($.eq((Object)type, (Object)AsmTypes.CLI_SESSION_ATTRIBUTE.asmType())) {
                    return new FieldCliSessionVariableAnnotationVisitor(av);
                }
                return av;
            }

            public void visitEnd() {
                FieldOptionAnnoInfo info;
                if (this.readFileContent && null != (info = CommanderByteCodeScanner.this.classInfo.fieldOptionAnnoInfo(this.fieldName))) {
                    info.setReadFileContent();
                }
                super.visitEnd();
            }

            private class FieldOptionAnnotationVisitor
            extends OptionAnnotationVisitorBase
            implements Opcodes {
                public FieldOptionAnnotationVisitor(AnnotationVisitor av, boolean optional, String fieldName, Type type) {
                    super(av, optional);
                    this.optionAnnoInfo = new FieldOptionAnnoInfo(fieldName, type, optional);
                }

                @Override
                public void visitEnd2() {
                    CommanderByteCodeScanner.this.classInfo.addFieldOptionAnnotationInfo((FieldOptionAnnoInfo)this.optionAnnoInfo);
                }
            }

            private class FieldCliSessionVariableAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                private String sessionVariableName;

                public FieldCliSessionVariableAnnotationVisitor(AnnotationVisitor av) {
                    super(327680, av);
                    this.sessionVariableName = CommanderFieldVisitor.this.fieldName;
                }

                public void visit(String name, Object value) {
                    super.visit(name, value);
                    if ("value".equals(name)) {
                        String key = S.string((Object)value);
                        this.sessionVariableName = S.blank((String)key) ? CommanderFieldVisitor.this.fieldName : key;
                    }
                }

                public void visitEnd() {
                    super.visitEnd();
                    CommanderByteCodeScanner.this.classInfo.addFieldSessionVariableAnnotInfo(CommanderFieldVisitor.this.fieldName, new SessionVariableAnnoInfo(this.sessionVariableName));
                }
            }
        }
    }
}

