/*
 * Decompiled with CFR 0.152.
 */
package act.cli.bytecode;

import act.app.App;
import act.cli.CliContext;
import act.cli.CommandExecutor;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommandParamMetaInfo;
import act.inject.param.CliContextParamLoader;
import act.inject.param.ParamValueLoaderManager;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Method;
import org.osgl.$;
import org.osgl.util.E;

public class ReflectedCommandExecutor
extends CommandExecutor {
    private static final Object[] DUMP_PARAMS = new Object[0];
    private CommandMethodMetaInfo methodMetaInfo;
    private App app;
    private CliContextParamLoader paramLoaderService;
    private ClassLoader cl;
    private Class[] paramTypes;
    private Class<?> commanderClass;
    private Method method;
    private MethodAccess methodAccess;
    private int commandIndex;
    private int paramCount;
    private CliContext.ParsingContext parsingContext;

    public ReflectedCommandExecutor(CommandMethodMetaInfo methodMetaInfo, App app) {
        this.methodMetaInfo = (CommandMethodMetaInfo)$.notNull((Object)methodMetaInfo);
        this.app = (App)$.NPE((Object)app);
        this.cl = app.classLoader();
        this.paramTypes = this.paramTypes();
        this.paramCount = methodMetaInfo.paramCount();
        this.commanderClass = $.classForName((String)methodMetaInfo.classInfo().className(), (ClassLoader)this.cl);
        try {
            this.method = this.commanderClass.getMethod(methodMetaInfo.methodName(), this.paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
        if (!methodMetaInfo.isStatic()) {
            this.methodAccess = MethodAccess.get(this.commanderClass);
            this.commandIndex = this.methodAccess.getIndex(methodMetaInfo.methodName(), this.paramTypes);
        } else {
            this.method.setAccessible(true);
        }
        this.paramLoaderService = (CliContextParamLoader)app.service(ParamValueLoaderManager.class).get(CliContext.class);
        this.buildParsingContext();
    }

    @Override
    public Object execute(CliContext context) {
        context.attribute("__act_method__", this.method);
        context.prepare(this.parsingContext);
        this.paramLoaderService.preParseOptions(this.method, this.methodMetaInfo, context);
        Object cmd = this.commanderInstance(context);
        Object[] params = this.params(cmd, context);
        return this.invoke(cmd, params);
    }

    @Override
    protected void releaseResources() {
        this.app = null;
        this.cl = null;
        this.commandIndex = 0;
        this.commanderClass = null;
        this.method = null;
        this.methodAccess = null;
        this.paramTypes = null;
        super.releaseResources();
    }

    private Object commanderInstance(CliContext context) {
        String commander = this.commanderClass.getName();
        Object inst = context.__commanderInstance(commander);
        if (null == inst) {
            inst = this.paramLoaderService.loadHostBean(this.commanderClass, context);
            context.__commanderInstance(commander, inst);
        }
        return inst;
    }

    private Class<?>[] paramTypes() {
        int paramCount = this.methodMetaInfo.paramCount();
        Class[] ca = new Class[paramCount];
        if (0 == paramCount) {
            return ca;
        }
        for (int i = 0; i < paramCount; ++i) {
            CommandParamMetaInfo param = this.methodMetaInfo.param(i);
            String className = param.type().getClassName();
            ca[i] = $.classForName((String)className, (ClassLoader)this.cl);
        }
        return ca;
    }

    private Object[] params(Object cmd, CliContext ctx) {
        if (0 == this.paramCount) {
            return DUMP_PARAMS;
        }
        return this.paramLoaderService.loadMethodParams(cmd, this.method, ctx);
    }

    private Object invoke(Object commander, Object[] params) {
        Object result;
        if (null != this.methodAccess) {
            try {
                result = this.methodAccess.invoke(commander, this.commandIndex, params);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
        try {
            result = this.method.invoke(null, params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
        return result;
    }

    private void buildParsingContext() {
        CliContextParamLoader loader = (CliContextParamLoader)this.app.service(ParamValueLoaderManager.class).get(CliContext.class);
        this.parsingContext = loader.buildParsingContext(this.commanderClass, this.method, this.methodMetaInfo);
    }
}

